<?php
session_start();
if (!isset($_SESSION["login"])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];

$requete = "SELECT * FROM t_classe INNER JOIN t_option ON t_classe.idO=t_option.idO
AND sec='Secondaire' ORDER BY t_classe.design ";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_admin.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="classe.php">
          <i class="bi bi-slack"></i>
          <span>Classe</span>
        </a>
      </li><!-- End Classe Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#mat-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Maternelle</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="mat-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
          <li>
            <a href="insmat.php" >
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presmat.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="ensmat.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="coursmat.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfmat.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraismat.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurymat.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Maternelle Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#prim-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Primaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="prim-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inspri.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="prespri.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enspri.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courspri.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfpri.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraispri.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurypri.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Primaire Nav -->

      <li class="nav-item">
        <a class="nav-link" data-bs-target="#sec-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Secondaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="sec-nav" class="nav-content collapse show" data-bs-parent="#sidebar-nav">
          <li>
            <a href="inssec.php" >
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presec.php" >
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enssec.php" >
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courssec.php" >
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfsec.php" >
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraissec.php" class="active">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurysec.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Secondaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="com.php">
          <i class="bi bi-megaphone-fill"></i>
          <span>E-Communication</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#grh-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-person-rolodex"></i><span>Ressources Humaines</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="grh-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="agent.php">
              <i class="bi bi-circle"></i><span>Employés</span>
            </a>
          </li>
          <li>
            <a href="conge.php">
              <i class="bi bi-circle"></i><span>Congés</span>
            </a>
          </li>
          <li>
            <a href="pres.php">
              <i class="bi bi-circle"></i><span>Présences</span>
            </a>
          </li>
          <li>
            <a href="avance.php">
              <i class="bi bi-circle"></i><span>Avances</span>
            </a>
          </li>
          <li>
            <a href="salaire.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
        </ul>
      </li><!-- End Ressources humaines Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#par-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-gear"></i><span>Paramètres</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="par-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="an.php">
              <i class="bi bi-circle"></i><span>Années Scolaires</span>
            </a>
          </li>
          <li>
            <a href="option.php">
              <i class="bi bi-circle"></i><span>Option</span>
            </a>
          </li>
          <li>
            <a href="cat.php">
              <i class="bi bi-circle"></i><span>Catégorie</span>
            </a>
          </li>
          <li>
            <a href="scat.php">
              <i class="bi bi-circle"></i><span>Sous-catégories</span>
            </a>
          </li>
          <li>
            <a href="ld.php">
              <i class="bi bi-circle"></i><span>Lignes de dépenses</span>
            </a>
          </li>
          <li>
            <a href="users.php">
              <i class="bi bi-circle"></i><span>Utilisateurs</span>
            </a>
          </li>
        </ul>
      </li><!-- End PArametre Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Frais Scolaires par Classe</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Frais Scolaires par Classe</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Liste des classes <span>| Toutes </span></h5>

                  <table class="table datatable">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Désignation</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"><?= $number ?></th>
                          <td><?php echo $data['design'] . " " . $data['designO'] . " " . $data['ord'] ?></td>
                          <td>
                            <a href="listeFraisSec.php?classe=<?=$data['idC'] ?>" class="btn btn-primary"><span class="bi bi-check-all"></span> Afficher les Frais</a>
                          </td>
                        </tr>
                      <?php $number++;} ?>
                    </tbody>
                  </table>



                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->



  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>