<?php
session_start();
require_once('../../include/connexiondb.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Validation des données (vous pouvez ajouter des validations plus spécifiques)
        $idA = $_POST["idA"];
        $designJ = $_POST["designJ"];
        $nomPres = $_POST["nomPres"];
        $nomSec = $_POST["nomSec"];
        $sectJ = $_POST["sectJ"];
        $loginJ = $_POST["loginJ"];
        $pwJ = password_hash($_POST["pwJ"], PASSWORD_DEFAULT);

        // Vérification de l'existence du login
        $sql = "SELECT * FROM users WHERE loginUser = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$loginJ]);

        if ($req->rowCount() > 0) {
            $msg_erreur = "Ce login est déjà dans le système!!!";
            if ($sectJ == "Maternelle") {
                header("Location:../jurymat.php?erreur=$msg_erreur");
            } elseif ($sectJ == "Primaire") {
                header("Location:../jurypri.php?erreur=$msg_erreur");
            } elseif ($sectJ == "Secondaire") {
                header("Location:../jurysec.php?erreur=$msg_erreur");
            }
            exit;
        }

        $sql = "SELECT * FROM t_ens WHERE loginEns = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$loginJ]);

        if ($req->rowCount() > 0) {
            $msg_erreur = "Ce login est déjà dans le système!!!";
            if ($sectJ == "Maternelle") {
                header("Location:../jurymat.php?erreur=$msg_erreur");
            } elseif ($sectJ == "Primaire") {
                header("Location:../jurypri.php?erreur=$msg_erreur");
            } elseif ($sectJ == "Secondaire") {
                header("Location:../jurysec.php?erreur=$msg_erreur");
            }
            exit;
        }

        // Vérification de l'existence du jury
        $sql = "SELECT * FROM t_jury WHERE designJ = ? OR loginJ = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$designJ, $loginJ]);

        if ($req->rowCount() > 0) {
            $msg_erreur = "Ce jury est déjà dans le système!!!";
            if ($sectJ == "Maternelle") {
                header("Location:../jurymat.php?erreur=$msg_erreur");
            } elseif ($sectJ == "Primaire") {
                header("Location:../jurypri.php?erreur=$msg_erreur");
            } elseif ($sectJ == "Secondaire") {
                header("Location:../jurysec.php?erreur=$msg_erreur");
            }
            exit;
        }

        // Insertion du nouveau jury
        $stmt = $pdo->prepare("INSERT INTO t_jury (idA, designJ, nomPres, nomSec, sectJ, loginJ, pwJ, etatJ) 
                              VALUES (:idA, :designJ, :nomPres, :nomSec, :sectJ, :loginJ, :pwJ, 'Actif')");

        $stmt->bindParam(':idA', $idA);
        $stmt->bindParam(':designJ', $designJ);
        $stmt->bindParam(':nomPres', $nomPres);
        $stmt->bindParam(':nomSec', $nomSec);
        $stmt->bindParam(':sectJ', $sectJ);
        $stmt->bindParam(':loginJ', $loginJ);
        $stmt->bindParam(':pwJ', $pwJ);

        $stmt->execute();

        $msg_erreur = "Jury ajouté avec succès";
        if ($sectJ == "Maternelle") {
            header("Location:../jurymat.php?succes=$msg_erreur");
        } elseif ($sectJ == "Primaire") {
            header("Location:../jurypri.php?succes=$msg_erreur");
        } elseif ($sectJ == "Secondaire") {
            header("Location:../jurysec.php?succes=$msg_erreur");
        }
        exit;
    } catch (PDOException $e) {
        $msg_erreur = "Erreur d'enregistrement!!!";
        if ($sectJ == "Maternelle") {
            header("Location:../jurymat.php?erreur=$msg_erreur");
        } elseif ($sectJ == "Primaire") {
            header("Location:../jurypri.php?erreur=$msg_erreur");
        } elseif ($sectJ == "Secondaire") {
            header("Location:../jurysec.php?erreur=$msg_erreur");
        }
        exit;
    }
}
