<?php
session_start();
require_once('../../include/connexiondb.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Récupérer les données du formulaire
    $idEns = $_POST["idEns"];
    $idC = $_POST["idC"];
    $idA = $_POST["idA"];
    $idSC = $_POST["idSC"];
    $designCours = $_POST["designCours"];
    $maxPer = $_POST["maxPer"];
    $maxEx = $_POST["maxEx"];
    $typeCours = $_POST["typeCours"];
    $niv = $_POST['niv'];

    // Vérification de l'existence
    $sql = "SELECT * FROM t_cours WHERE idEns = ? AND idC = ? AND idA = ? AND designCours = ?";
    $req = $pdo->prepare($sql);
    $req->execute([$idEns, $idC, $idA, $designCours]);

    if ($req->rowCount() > 0) {
        #Message de succès
        $msg_erreur = "Ce cours existe deja dans le système!!!";
        if ($niv == "Maternelle") {
            header("Location:../coursmat.php?erreur=$msg_erreur");
        } elseif ($niv == "Primaire") {
            header("Location:../courspri.php?erreur=$msg_erreur");
        } elseif ($niv == "Secondaire") {
            header("Location:../courssec.php?erreur=$msg_erreur");
        }
        exit;
    }

    // Préparer la requête d'insertion
    $sql = "INSERT INTO t_cours (idEns, idC, idA, idSC, designCours, maxPer, maxEx, typeCours) VALUES (:idEns, :idC, :idA, :idSC, :designCours, :maxPer, :maxEx, :typeCours)";

    // Préparation de la requête SQL avec PDO
    $stmt = $pdo->prepare($sql);

    // Liaison des paramètres
    $stmt->bindParam(":idEns", $idEns, PDO::PARAM_INT);
    $stmt->bindParam(":idC", $idC, PDO::PARAM_INT);
    $stmt->bindParam(":idA", $idA, PDO::PARAM_INT);
    $stmt->bindParam(":idSC", $idSC, PDO::PARAM_INT);
    $stmt->bindParam(":designCours", $designCours, PDO::PARAM_STR);
    $stmt->bindParam(":maxPer", $maxPer, PDO::PARAM_STR);
    $stmt->bindParam(":maxEx", $maxEx, PDO::PARAM_STR);
    $stmt->bindParam(":typeCours", $typeCours, PDO::PARAM_STR);

    // Exécution de la requête
    if ($stmt->execute()) {
        // Redirigez l'utilisateur vers une page de confirmation ou une autre page
        $msg_erreur = "Cours ajouté avec succès";
        if ($niv == "Maternelle") {
            header("Location:../coursmat.php?succes=$msg_erreur");
        } elseif ($niv == "Primaire") {
            header("Location:../courspri.php?succes=$msg_erreur");
        } elseif ($niv == "Secondaire") {
            header("Location:../courssec.php?succes=$msg_erreur");
        }
        exit;
    } else {
        $msg_erreur = "Erreur lors de l'insertion des données";
        if ($niv == "Maternelle") {
            header("Location:../coursmat.php?erreur=$msg_erreur");
        } elseif ($niv == "Primaire") {
            header("Location:../courspri.php?erreur=$msg_erreur");
        } elseif ($niv == "Secondaire") {
            header("Location:../courssec.php?erreur=$msg_erreur");
        }
        exit;
    }
}
