<?php
session_start();
require_once('../../include/connexiondb.php');

function redirectWithError($msg)
{
    header("Location: ../agent.php?erreur=$msg");
    exit();
}

function redirectWithSuccess($msg)
{
    header("Location: ../agent.php?succes=$msg");
    exit();
}

if (
    $_SERVER['REQUEST_METHOD'] === 'POST'
) {
    try {

        $nomEns = $_POST['nomEns'];
        $imageEns = $_POST['imageEns'];
        $nivEns = $_POST['nivEns'];
        $Etat = $_POST['etatEns'];
        $log = $_POST['log'];
        $pw = $_POST['pw'];
        $hash = password_hash($pw, PASSWORD_DEFAULT);

        // Vérification de l'existence du login
        $sql = "SELECT * FROM t_jury WHERE loginJ = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$log]);

        if ($req->rowCount() > 0) {
            redirectWithError("Ce Login est déjà dans le système");
        }

        $sql = "SELECT * FROM users WHERE loginUser = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$log]);

        if ($req->rowCount() > 0) {
            redirectWithError("Ce Login est déjà dans le système");
        }

        // Vérification de l'existence de l'utilisateur
        $sql = "SELECT * FROM t_ens WHERE nomEns = ? OR loginEns = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$nomEns, $log]);

        if ($req->rowCount() > 0) {
            redirectWithError("Cet enseignant a déjà un espace dans le système");
        }

        // Insertion des données dans la table
        $sql = "INSERT INTO t_ens (`nomEns`,`nivEns`,`loginEns`,`pwEns`,`imageEns`,`etatEns`) 
        VALUES (?, ?, ?, ?, ?, ?)";
        $req = $pdo->prepare($sql);
        $req->execute([$nomEns, $nivEns, $log, $hash, $imageEns, $Etat]);

        redirectWithSuccess("Espace accordé avec succès");
    } catch (PDOException $e) {
        redirectWithError("Erreur de traitement");
    }
} else {
    redirectWithError("Une erreur dans les issets");
}
