<?php
session_start();
require_once('../../include/connexiondb.php');

define('UPLOAD_PATH', '../../uploads/');
define('MAX_PHOTO_SIZE', 10000000);

function redirectWithError($msg)
{
    header("Location: ../users.php?erreur=$msg");
    exit();
}

function redirectWithSuccess($msg)
{
    header("Location: ../users.php?succes=$msg");
    exit();
}

if (
    isset($_POST['addUserBtn']) &&
    isset($_POST['nom']) &&
    isset($_POST['log']) &&
    isset($_POST['pw']) &&
    isset($_POST['fonction']) &&
    isset($_FILES['photo'])
) {
    try {
        $nom = $_POST['nom'];
        $log = $_POST['log'];
        $pw = $_POST['pw'];
        $hash = password_hash($pw, PASSWORD_DEFAULT);
        $Fonction = $_POST['fonction'];
        $Etat = "Desactiver";
        $photo = $_FILES['photo'];
        $photo_name = $photo['name'];
        $photo_size = $photo['size'];
        $tmp_name = $photo['tmp_name'];
        $error = $photo['error'];

        // Validation des données du formulaire
        if (empty($nom) || empty($log) || empty($pw) || empty($Fonction) || !isset($photo)) {
            redirectWithError("Tous les champs sont obligatoires");
        }

        // Vérification de l'existence du login
        $sql = "SELECT * FROM t_jury WHERE loginJ = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$log]);

        if ($req->rowCount() > 0) {
            redirectWithError("Ce Login est déjà dans le système");
        }

        // Vérification de l'existence de l'utilisateur
        $sql = "SELECT * FROM users WHERE nomUser = ? OR loginUser = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$nom, $log]);

        if ($req->rowCount() > 0) {
            redirectWithError("Cet Utilisateur est déjà dans le système");
        }

        // Traitement de l'upload de l'image
        if ($error === 0) {
            if ($photo_size > MAX_PHOTO_SIZE) {
                redirectWithError("Une Image ne doit pas dépasser 10 Méga");
            } else {
                $img_ex = pathinfo($photo_name, PATHINFO_EXTENSION);
                $img_ex_lc = strtolower($img_ex);
                $allowed_exs = array("jpeg", "jpg", "png");

                if (in_array($img_ex_lc, $allowed_exs)) {
                    $new_name_photo = uniqid("USER-", true) . '.' . $img_ex_lc;
                    $image_Path_upload = UPLOAD_PATH . $new_name_photo;
                    move_uploaded_file($tmp_name, $image_Path_upload);

                    // Insertion des données dans la table
                    $sql = "INSERT INTO users (`nomUser`, `loginUser`, `pw`, `fonction`, `imageUser`, `etatUser`) 
                            VALUES (?, ?, ?, ?, ?, ?)";
                    $req = $pdo->prepare($sql);
                    $req->execute([$nom, $log, $hash, $Fonction, $new_name_photo, $Etat]);

                    redirectWithSuccess("Utilisateur ajouté avec succès");
                } else {
                    redirectWithError("Erreur d'extension (Seulement JPEG, JPG, PNG)");
                }
            }
        } else {
            redirectWithError("Une erreur s'est produite lors de l'upload");
        }
    } catch (PDOException $e) {
        redirectWithError("Erreur de traitement");
    }
} else {
    redirectWithError("Une erreur dans les issets");
}
