<?php
session_start();
require_once('../../include/connexiondb.php');
require_once('../../include/phpqrcode/qrlib.php');

define('UPLOAD_PATH', '../../uploads/');
define('MAX_PHOTO_SIZE', 10000000);

function redirectWithError($msg)
{
    header("Location: ../agent.php?erreur=$msg");
    exit();
}

function redirectWithSuccess($msg)
{
    header("Location: ../agent.php?succes=$msg");
    exit();
}

if (
    $_SERVER['REQUEST_METHOD'] === 'POST'
) {
    try {

        $nomA = $_POST['nomA'];
        $sexA = $_POST['sexA'];
        $civA = $_POST['civA'];
        $telA = $_POST['telA'];
        $foncA = $_POST['foncA'];
        $nivA = $_POST['nivA'];
        $adA = $_POST['adA'];
        $salA = $_POST['salA'];
        $photo = $_FILES['imgA'];
        $photo_name = $photo['name'];
        $photo_size = $photo['size'];
        $tmp_name = $photo['tmp_name'];
        $error = $photo['error'];

        // Vérification de l'existence de l'agent
        $sql = "SELECT * FROM agent WHERE nomA = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$nom]);

        if ($req->rowCount() > 0) {
            redirectWithError("Cet employé existe déjà dans le système");
        }

        //Le salaire doit etre en numérique
        if (!is_numeric($salA)) {
            redirectWithError("Le salaire doit être un numérique s'il vous plaît.");
        }

        // Traitement de l'upload de l'image
        if ($error === 0) {
            if ($photo_size > MAX_PHOTO_SIZE) {
                redirectWithError("Une Image ne doit pas dépasser 10 Méga");
            } else {
                $img_ex = pathinfo($photo_name, PATHINFO_EXTENSION);
                $img_ex_lc = strtolower($img_ex);
                $allowed_exs = array("jpeg", "jpg", "png");

                if (in_array($img_ex_lc, $allowed_exs)) {
                    $new_name_photo = uniqid("AGENT-", true) . '.' . $img_ex_lc;
                    $image_Path_upload = UPLOAD_PATH . $new_name_photo;
                    move_uploaded_file($tmp_name, $image_Path_upload);

                    // Insertion des données dans la table
                    $sql = "INSERT INTO agent(`nomA`,`sexA`,`civA`,`telA`,`adA`,`foncA`,`nivA`,`salA`,`imgA`,`etatA`) 
                    VALUES(?,?,?,?,?,?,?,?,?,?)";
                    $req = $pdo->prepare($sql);
                    $req->execute([$nomA, $sexA, $civA, $telA, $adA, $foncA, $nivA, $salA, $new_name_photo, 'En service']);
                    
                    //LastInsert
                    $idA = $pdo->lastInsertId();
                    //QrCode
                    $path = '../../uploads/';
                    $qrcode = $path . 'AGENTQRC-' . $idA . ".png";
                    QRcode::png($idA, $qrcode, 'H', 4, 4);

                    redirectWithSuccess("Employé ajouté avec succès");
                } else {
                    redirectWithError("Erreur d'extension (Seulement JPEG, JPG, PNG)");
                }
            }
        } else {
            // Aucune image téléchargée, utiliser l'image par défaut
            $new_name_photo = "user.png";

            // Insertion des données dans la table
            $sql = "INSERT INTO agent(`nomA`,`sexA`,`civA`,`telA`,`adA`,`foncA`,`nivA`,`salA`,`imgA`,`etatA`) 
            VALUES(?,?,?,?,?,?,?,?,?,?)";
            $req = $pdo->prepare($sql);
            $req->execute([$nomA, $sexA, $civA, $telA, $adA, $foncA, $nivA, $salA, $new_name_photo, 'En service']);

            //LastInsert
            $idA = $pdo->lastInsertId();
            //QrCode
            $path = '../../uploads/';
            $qrcode = $path . 'AGENTQRC-' . $idA . ".png";
            QRcode::png($idA, $qrcode, 'H', 4, 4);
            
            redirectWithSuccess("Employé ajouté avec succès");
        }
    } catch (PDOException $e) {
        redirectWithError("Erreur de traitement");
    }
} else {
    redirectWithError("Une erreur dans les issets");
}
