<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');

$requete = "SELECT * FROM users WHERE fonction='Receptionniste'
OR fonction='Caissier(e)' OR fonction='GRH' OR fonction='DD' 
OR fonction='Responsable Financier(e)' OR fonction='Enseignant' OR fonction='GESTOCK'
ORDER BY nomUser ASC";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_admin.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="classe.php">
          <i class="bi bi-slack"></i>
          <span>Classe</span>
        </a>
      </li><!-- End Classe Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#mat-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Maternelle</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="mat-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
          <li>
            <a href="insmat.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presmat.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="ensmat.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="coursmat.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfmat.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraismat.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurymat.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Maternelle Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#prim-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Primaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="prim-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inspri.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="prespri.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enspri.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courspri.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfpri.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraispri.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurypri.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Primaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#sec-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Secondaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="sec-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inssec.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presec.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enssec.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courssec.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfsec.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraissec.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurysec.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Secondaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="com.php">
          <i class="bi bi-megaphone-fill"></i>
          <span>E-Communication</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#grh-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-person-rolodex"></i><span>Ressources Humaines</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="grh-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="agent.php">
              <i class="bi bi-circle"></i><span>Employés</span>
            </a>
          </li>
          <li>
            <a href="conge.php">
              <i class="bi bi-circle"></i><span>Congés</span>
            </a>
          </li>
          <li>
            <a href="pres.php">
              <i class="bi bi-circle"></i><span>Présences</span>
            </a>
          </li>
          <li>
            <a href="avance.php">
              <i class="bi bi-circle"></i><span>Avances</span>
            </a>
          </li>
          <li>
            <a href="salaire.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
        </ul>
      </li><!-- End Ressources humaines Nav -->

      <li class="nav-item">
        <a class="nav-link" data-bs-target="#par-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-gear"></i><span>Paramètres</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="par-nav" class="nav-content collapse show" data-bs-parent="#sidebar-nav">
          <li>
            <a href="an.php">
              <i class="bi bi-circle"></i><span>Années Scolaires</span>
            </a>
          </li>
          <li>
            <a href="option.php">
              <i class="bi bi-circle"></i><span>Option</span>
            </a>
          </li>
          <li>
            <a href="cat.php">
              <i class="bi bi-circle"></i><span>Catégorie</span>
            </a>
          </li>
          <li>
            <a href="scat.php">
              <i class="bi bi-circle"></i><span>Sous-catégories</span>
            </a>
          </li>
          <li>
            <a href="ld.php">
              <i class="bi bi-circle"></i><span>Lignes de dépenses</span>
            </a>
          </li>
          <li>
            <a href="users.php" class="active">
              <i class="bi bi-circle"></i><span>Utilisateurs</span>
            </a>
          </li>
        </ul>
      </li><!-- End PArametre Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Utilisateurs</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Utilisateurs</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Gestion des utilisateurs <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddService" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a> </span></h5>

                  <table class="table datatable">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Nom</th>
                        <th scope="col">Login</th>
                        <th scope="col">Fonction</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php while ($serv = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"> <a class="btn" data-bs-toggle="modal" data-bs-target="#ModalViewPhotoService<?php echo $serv['idUser'] ?>"><img src="../uploads/<?php echo $serv['imageUser'] ?>" width="40" height="40" class="img-fluid rounded-4" alt=""></a></th>
                          <td><?php echo $serv['nomUser'] ?></td>
                          <td><?php echo $serv['loginUser'] ?></td>
                          <td><?php echo $serv['fonction'] ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateService<?php echo $serv['idUser'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> <strong> Modifier </strong> </a>
                            &nbsp; &nbsp;
                            <a href="php_include/etatUser.php?idUser=<?php echo $serv['idUser'] ?>&etat=<?php echo $serv['etatUser'] ?>">
                              <?php
                              if ($serv['etatUser'] == 'Desactiver')
                                echo "<span class='btn btn-danger'> <i class='bi bi-x-circle-fill'></i> <strong> Désactiver </strong> </span>";
                              else
                                echo "<span class='btn btn-success'> <i class='bi bi-check-circle-fill'></i> <strong> Activer </strong> </span>";
                              ?>
                            </a>
                          </td>
                        </tr>
                      <?php include('modal_include/ModalmodifierUser.php');
                      } ?>
                    </tbody>
                  </table>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

  <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalAddService" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter un utilisateur</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addUser.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Nom</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                  <input type="text" name="nom" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le nom SVP !</div>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Fonction</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                  <select name="fonction" class="form-control" id="titre" required>
                    <option value="Receptionniste">Receptionniste</option>
                    <option value="Caissier(e)">Caissier(e)</option>
                    <option value="Responsable Financier(e)">Responsable Financier(e)</option>
                    <option value="DD">DD</option>
                    <option value="GRH">GRH</option>
                    <option value="GESTOCK">GESTOCK</option>
                  </select>
                  <div class="invalid-feedback">Veillez saisir la fonction SVP !</div>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Login</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                  <input type="text" name="log" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le login SVP !</div>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="renewpassword" class="form-label">Mot de passe</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-lock"></i></span>
                  <input type="text" name="pw" class="form-control" id="renewPassword" required>
                  <div class="invalid-feedback">Veillez saisir le mot de passe !</div>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="photo" class="form-label">Photo</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-file-earmark-image"></i></span>
                  <input type="file" name="photo" class="form-control" id="photo" required>
                  <div class="invalid-feedback">Veillez choisir une photo !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addUserBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>