<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');

#Paiement
$idUser = $_SESSION['id'];
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord = "SELECT count(*) AS total_records FROM 
t_redevable INNER JOIN t_classe ON t_redevable.idC=t_classe.idC 
INNER JOIN t_an ON t_redevable.idA=t_an.idA 
INNER JOIN t_option ON t_classe.idO=t_option.idO
INNER JOIN t_inscrit ON t_redevable.idI = t_inscrit.idI INNER JOIN
t_payered ON t_redevable.idR = t_payered.idR INNER JOIN
users ON t_payered.idUser = users.idUser WHERE
users.idUser='$idUser' AND nom LIKE '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records']; 
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requete = "SELECT * FROM 
t_redevable INNER JOIN t_classe ON t_redevable.idC=t_classe.idC 
INNER JOIN t_an ON t_redevable.idA=t_an.idA 
INNER JOIN t_option ON t_classe.idO=t_option.idO
INNER JOIN t_inscrit ON t_redevable.idI = t_inscrit.idI INNER JOIN
t_payered ON t_redevable.idR = t_payered.idR INNER JOIN
users ON t_payered.idUser = users.idUser WHERE
users.idUser='$idUser' AND nom LIKE '%$des%'
ORDER BY datePR DESC LIMIT $offset, $total_records_per_page";
$resultat = $pdo->query($requete);
?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="pf.php">
          <i class="bi bi-currency-exchange"></i>
          <span>Paiement des frais scolaires</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link" href="pr.php">
          <i class="bi bi-credit-card-fill"></i>
          <span>Paiement des redevabilités</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Paiement des redevabilités</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Paiement</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data PAIEMENT -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Gestion des paiements des redevabilités <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddPR" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a>
                      | <a data-bs-toggle="modal" data-bs-target="#modalPrintPR" class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER</a>
                    </span></h5>

                  <form method="get" action="pr.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Elève</th>
                        <th scope="col">Classe</th>
                        <th scope="col">Année</th>
                        <th scope="col">A payer</th>
                        <th scope="col">Payé</th>
                        <th scope="col">Date</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"> <?php echo $number; ?></th>
                          <td><?php echo $data['nom'] ?></td>
                          <td><?php echo $data['design'] . " " . $data['designO'] . " " . $data['ord'] ?></td>
                          <td><?php echo $data['designA'] ?></td>
                          <td class="text-danger"><?php echo $data['montR'].' $' ?></td>
                          <td><strong><?php echo $data['montPR'] . ' $' ?></strong></td>
                          <td><?php echo date('d-m-Y', strtotime($data['datePR'])) ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintRecuRedevable<?php echo $data['idR'] ?>" class="btn btn-info"><span class="bi bi-printer-fill"></span> </a>
                          </td>
                        </tr>
                      <?php $number++;
                        include('modal_include/ModalmodifierFrais.php');
                      } ?>
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                      echo "href='pr.php?page_no=$previous_page&des=$des'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='pr.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='pr.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                      echo "href='pr.php?page_no=$next_page'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='pr.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    } ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->

      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

  <!-- MODAL ADD Agent -->
  <div class="modal fade" id="modalAddPR" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter un paiement</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addRedevable.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="idClasse" class="form-label">Elève Redevable</label>
                <select class="form-select search-classe" name="idR" id="idClasse">
                  <?php
                  $requeteAg = "SELECT * FROM t_redevable INNER JOIN 
                  t_classe ON t_redevable.idC=t_classe.idC 
                  INNER JOIN t_an ON t_redevable.idA=t_an.idA 
                  INNER JOIN t_option ON t_classe.idO=t_option.idO
                  INNER JOIN t_inscrit ON t_redevable.idI = t_inscrit.idI 
                  WHERE t_redevable.montR > 0 ORDER BY nom ASC";
                  $resultatAg = $pdo->query($requeteAg);
                  while ($result = $resultatAg->fetch()) { ?>
                    <option value="<?php echo $result['idR']; ?>">
                      <?php echo $result['nom'] . " - ". $result['montR'] ." $ - " . $result['design'] . " " . $result['designO'] . " " . $result['ord'] . " - " . $result['designA'] ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Montant</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-currency-exchange"></i></span>
                  <input type="text" name="montPR" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le Montant SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addPayePRBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD CLIENT-->

  <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalPrintPR" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Print différentes redevabilités</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="../include/journalRedevableCaisse.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">

              <div class="col-md-12 col-lg-12">
                <br>
                <label for="titre" class="form-label">Première Date</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                  <input type="date" name="date1" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                </div>
              </div>

              <div class="col-md-12 col-lg-12">
                <br>
                <label for="titre" class="form-label">Seconde Date</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                  <input type="date" name="date2" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="printPresBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>