<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];

$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 10;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requeteRecord = "SELECT count(*) AS total_records FROM t_autsortie
INNER JOIN t_inscrit ON t_inscrit.idI=t_autsortie.idI
INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
INNER JOIN t_option ON t_classe.idO=t_option.idO INNER JOIN t_an 
ON t_inscrit.idA=t_an.idA WHERE t_inscrit.idA='$ResultmaxAS'
 AND t_inscrit.nom LIKE '%$des%' OR t_autsortie.motif LIKE '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requete = "SELECT * FROM t_autsortie
INNER JOIN t_inscrit ON t_inscrit.idI=t_autsortie.idI
INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
INNER JOIN t_option ON t_classe.idO=t_option.idO INNER JOIN t_an 
ON t_inscrit.idA=t_an.idA WHERE t_inscrit.idA='$ResultmaxAS'
 AND t_inscrit.nom LIKE '%$des%' OR t_autsortie.motif LIKE '%$des%'
ORDER BY t_autsortie.dateA ASC LIMIT $offset, $total_records_per_page";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent2.php"); ?>

  <!-- Menu principal -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="cc.php">
          <i class="bi bi-person-video2"></i>
          <span>Conduites</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="com.php">
          <i class="bi bi-envelope-paper-fill"></i>
          <span>E-communication</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link" href="as.php">
          <i class="bi bi-escape"></i>
          <span>Autorisation de sortie</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="pun.php">
          <i class="bi bi-x-diamond-fill"></i>
          <span>Punitions</span>
        </a>
      </li><!-- End Dashboard Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Autorisation de sortie</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Autorisation de sortie</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Gestion des autorisations de sortie <span>| <a data-bs-toggle="modal" data-bs-target="#modalAdd" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a></span></h5>

                  <form method="get" action="as.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Elève</th>
                        <th scope="col">Classe</th>
                        <th scope="col">Motif</th>
                        <th scope="col">Heure</th>
                        <th scope="col">Date</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"><img src="../uploads/<?php echo $data['photo'] ?>" width="40" height="40" class="img-fluid rounded-4" alt=""></th>
                          <td><?php echo $data['nom'] ?></td>
                          <td><?php echo $data['design'] . " " . $data['designO'] . " " . $data['ord'] ?></td>
                          <td><?php echo $data['motif'] ?></td>
                          <td><?php echo $data['hS'] ?></td>
                          <td><?php echo date('d-m-Y', strtotime($data['dateA'])) ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateAut<?php echo $data['idAut'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span></a>
                            &nbsp;&nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateStatut<?php echo $data['idAut'] ?>">
                              <?php
                              if ($data['statut'] == 'En attente')
                                echo "<span class='btn btn-warning'> <i class='bi bi-x-circle-fill'></i> En attente </span>";
                              else
                                echo "<span class='btn btn-success'> <i class='bi bi-check-circle-fill'></i> Approuvée </span>";
                              ?>
                            </a>
                            &nbsp;&nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintAut<?php echo $data['idAut'] ?>" class="btn btn-warning"><span class="bi bi-printer-fill"></span></a>
                          </td>
                        </tr>
                      <?php $number++;
                        include('modal_include/modalModif.php');
                      } ?>
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                      echo "href='as.php?page_no=$previous_page&des=$des'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='as.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='as.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='as.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='as.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='as.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                      echo "href='as.php?page_no=$next_page'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='as.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    }
                    ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->
          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MODAL ADD -->
  <div class="modal fade" id="modalAdd" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Accordée une autorisation de sortie</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addAut.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Elève</label>
                <select class="form-select search-classe" name="idI">
                  <?php
                  $requeteAg = "SELECT * FROM t_inscrit 
                      INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
                      INNER JOIN t_option ON t_classe.idO=t_option.idO
                      INNER JOIN t_an ON t_inscrit.idA=t_an.idA 
                      WHERE t_inscrit.idA='$ResultmaxAS' ORDER BY t_inscrit.nom ASC";
                  $resultatAg = $pdo->query($requeteAg);
                  while ($result = $resultatAg->fetch()) { ?>
                    <option value="<?php echo $result['idI']; ?>">
                      <?php echo $result['nom'] . ' - ' . $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Motif</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                  <input type="text" name="motif" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le motif SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>