<?php
session_start();
require_once('../../include/connexiondb.php');

// Fonction pour insérer ou mettre à jour les données d'un élève dans la table spécifiée
function insertOrUpdateCond($pdo, $tableName, $idI, $idC, $idA, $data) {
    // Vérifier si l'enregistrement existe déjà
    $query = "SELECT * FROM $tableName WHERE idI = :idI AND idC = :idC AND idA = :idA";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        // L'enregistrement existe, effectuer une mise à jour
        $updateQuery = "UPDATE $tableName SET ";
        foreach ($data as $key => $value) {
            $updateQuery .= "$key = :$key, ";
        }
        $updateQuery = rtrim($updateQuery, ", ");
        $updateQuery .= " WHERE idI = :idI AND idC = :idC AND idA = :idA";

        $stmt = $pdo->prepare($updateQuery);

        foreach ($data as $key => $value) {
            $stmt->bindParam(":$key", $data[$key], PDO::PARAM_STR);
        }
        
        // Ajouter les paramètres idI et idCours pour la clause WHERE
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);

        return $stmt->execute();
    } else {
        // L'enregistrement n'existe pas, effectuer une insertion
        $columns = implode(", ", array_keys($data));
        $values = implode(", ", array_map(function ($key) {
            return ":$key";
        }, array_keys($data)));

        $insertQuery = "INSERT INTO $tableName (idI, idC, idA, $columns) VALUES (:idI, :idC, :idA, $values)";

        $stmt = $pdo->prepare($insertQuery);
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);

        foreach ($data as $key => &$value) {
            $stmt->bindParam(":$key", $value, PDO::PARAM_STR);
        }
        
        return $stmt->execute();
    }
}

// Soumission du formulaire
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['idA']) && isset($_POST['idC'])) {
        $idC = $_POST['idC'];
        $idA = $_POST['idA'];

        // Récuperation de la section
        $requestSection="SELECT * FROM t_classe WHERE idC='$idC'";
        $stmSection=$pdo->query($requestSection)->fetch();
        $sectionClasse = $stmSection['sec'];

        // Récupérer le nombre d'élèves par classe et année
        $numStudents=$pdo->query("SELECT * FROM t_inscrit
         WHERE idC='$idC' And idA='$idA'")->rowCount();

        for ($i = 1; $i <= $numStudents; $i++) {
            $idI = $_POST["idI_$i"];
            
            // Appeler la fonction pour insérer ou mettre à jour
            if ($sectionClasse == "Maternelle") {
                // Les champs sont des notes
                $data1 = array(
                    'P1' => ($_POST["p1_$i"]=='') ? '' : $_POST["p1_$i"],
                    'P2' => ($_POST["p2_$i"]=='') ? '' : $_POST["p2_$i"],
                    'P3' => ($_POST["p3_$i"]=='') ? '' : $_POST["p3_$i"],
                );
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateCond($pdo, 't_cond_mat', $idI, $idC, $idA, $data1);
            } elseif ($sectionClasse == "Primaire") {
                // Les champs sont des notes
                $data2 = array(
                    'P1' => ($_POST["p1_$i"]=='') ? '' : $_POST["p1_$i"],
                    'P2' => ($_POST["p2_$i"]=='') ? '' : $_POST["p2_$i"],
                    'P3' => ($_POST["p3_$i"]=='') ? '' : $_POST["p3_$i"],
                    'P4' => ($_POST["p4_$i"]=='') ? '' : $_POST["p4_$i"],
                    'P5' => ($_POST["p5_$i"]=='') ? '' : $_POST["p5_$i"],
                    'P6' => ($_POST["p6_$i"]=='') ? '' : $_POST["p6_$i"],
                );
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateCond($pdo, 't_cond_pri', $idI, $idC, $idA, $data2);
            } elseif ($sectionClasse == "Secondaire") {
                // Les champs sont des notes
                $data3 = array(
                    'P1' => ($_POST["p1_$i"]=='') ? '' : $_POST["p1_$i"],
                    'P2' => ($_POST["p2_$i"]=='') ? '' : $_POST["p2_$i"],
                    'P3' => ($_POST["p3_$i"]=='') ? '' : $_POST["p3_$i"],
                    'P4' => ($_POST["p4_$i"]=='') ? '' : $_POST["p4_$i"],
                );
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateCond($pdo, 't_cond_sec', $idI, $idC, $idA, $data3);
            }
        }
        
        // Rediriger ou afficher un message de confirmation après l'enregistrement/mise à jour
        $msg_erreur = "Conduites disciplinaires des élèves initialisées avec succès";
        header("Location:../conduite.php?idC=$idC&succes=$msg_erreur"); 

    }else {
        $msg_erreur = "Il y a une erreur lors de l'initialisation de conduites disciplinaires des élèves.";
        header("Location:../conduite.php??idC=$idC&erreur=$msg_erreur");  
    }
}
?>