<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('php_include/some_fonctions.php');
include("php_include/analyseDateSet.php");
?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_stockagent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#gest-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Gestions</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="gest-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="clients.php">
              <i class="bi bi-circle"></i><span>Clients</span>
            </a>
          </li>
          <li>
            <a href="fourn.php">
              <i class="bi bi-circle"></i><span>Fournisseurs</span>
            </a>
          </li>
          <li>
            <a href="categ.php">
              <i class="bi bi-circle"></i><span>Catégories</span>
            </a>
          </li>
        </ul>
      </li><!-- End Gestions Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="med.php">
          <i>&#9764;</i>
          <span>Stock Produit</span>
        </a>
      </li><!-- End stock Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="investis.php">
          <i class="bi bi-snow2"></i>
          <span>Stock Investi</span>
        </a>
      </li><!-- End Stock Investi Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="approv.php">
          <i class="bi bi-cart4"></i>
          <span>Approvisionnement</span>
        </a>
      </li><!-- End Approv Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="ventes.php">
          <i class="bi bi-cart-fill"></i>
          <span>Ventes</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="serv_cre.php">
          <i class="bi bi-activity"></i>
          <span>Suivi des Créances</span>
        </a>
      </li><!-- End Créances Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="requis.php">
          <i class="bi bi-stack"></i>
          <span>Requisition</span>
        </a>
      </li><!-- End Requisition Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="invet.php">
          <i class="bi bi-stickies-fill"></i>
          <span>Inventaire</span>
        </a>
      </li><!-- End Inventaire Page Nav -->

      <li class="nav-item">
        <a class="nav-link" href="analyse.php">
          <i class="bi bi-slack"></i>
          <span>Analyse</span>
        </a>
      </li><!-- End Analyse Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Analyse</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Analyse Financière</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- Recettes Card -->
        <div class="col-xxl-6 col-md-6">
          <div class="card info-card sales-card">

            <div class="card-body">
              <h5 class="card-title">Recettes <span>| CA</span></h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i>&#9764;</i>
                </div>
                <div class="ps-3">
                  <h6 class="text-success"><?php if ($dateRow > 0) echo number_format($data['ventes'], 2, '.', ' ') ?></h6>
                  <span class="text-primary small pt-1 fw-bold"> En FC </span>

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Recettes Card -->

        <!-- Creances Card -->
        <div class="col-xxl-6 col-md-6">
          <div class="card info-card sales-card">

            <div class="card-body">
              <h5 class="card-title">Créances <span>| Crédits</span></h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bi bi-credit-card-fill"></i>
                </div>
                <div class="ps-3">
                  <h6 class="text-danger"><?php if ($dateRow > 0) echo number_format($data['creances'], 2, '.', ' ') ?></h6>
                  <span class="text-primary small pt-1 fw-bold"> En FC </span>

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Creances Card -->

        <!-- Depenses Card -->
        <div class="col-xxl-6 col-md-6">
          <div class="card info-card sales-card">

            <div class="card-body">
              <h5 class="card-title">Dépenses <span>| Autres Charges</span></h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bi bi-plus-slash-minus"></i>
                </div>
                <div class="ps-3">
                  <h6 class="text-warning"><?php if ($dateRow > 0) echo number_format($data['depenses'], 2, '.', ' ') ?></h6>
                  <span class="text-primary small pt-1 fw-bold"> En FC </span>

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Dépenses Card -->

        <!-- Caisse Card -->
        <div class="col-xxl-6 col-md-6">
          <div class="card info-card sales-card">

            <div class="card-body">
              <h5 class="card-title">Total Caisse <span>| Recettes - Dépenses</span></h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bi bi-currency-exchange"></i>
                </div>
                <div class="ps-3">
                  <h6><?php if ($dateRow > 0) echo number_format($data['net'], 2, '.', ' ') ?></h6>
                  <span class="text-primary small pt-1 fw-bold"> En FC </span>

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Caisse Card -->

        <!-- TAbele data INVEST -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Mouvement de notre Investissement selon les périodes <span>| Notre Evolution</h5>
                  <!-- Line Chart -->
                  <div id="lineChart"></div>

                  <script>
                    document.addEventListener("DOMContentLoaded", () => {
                      new ApexCharts(document.querySelector("#lineChart"), {
                        series: [{
                          name: "Investissement",
                          data: [<?= round($CAYearInvet, 2) ?>, <?= round($CASixLastMonthInvet, 2) ?>,
                            <?= round($CALastYearInvet, 2) ?>, <?= round($CATwoLastYearInvet, 2) ?>,
                            <?= round($CAThreeLastYearInvet, 2) ?>, <?= round($CAFourLastYearInvet, 2) ?>,
                            <?= round($CAFiveLastYearInvet, 2) ?>
                          ]
                        }],
                        chart: {
                          height: 350,
                          type: 'line',
                          zoom: {
                            enabled: false
                          }
                        },
                        dataLabels: {
                          enabled: false
                        },
                        stroke: {
                          curve: 'straight'
                        },
                        grid: {
                          row: {
                            colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns
                            opacity: 0.5
                          },
                        },
                        xaxis: {
                          categories: ['Cette Année', 'Six Mois Passés', 'Une Année Passée',
                            'Deux Années Passées', 'Trois Années Passées',
                            'Quatre Années Passées', 'Cinq Années Passées'
                          ],
                        }
                      }).render();
                    });
                  </script>
                  <!-- End Line Chart -->
                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->

        <!-- TAbele data CA -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Mouvement de notre Chiffre d'Affaire selon les périodes <span>| Notre Evolution</h5>

                  <!-- Bar Chart -->
                  <div id="barChart"></div>

                  <script>
                    document.addEventListener("DOMContentLoaded", () => {
                      new ApexCharts(document.querySelector("#barChart"), {
                        series: [{
                          data: [<?= $CAToday ?>, <?= $CAWeek ?>, <?= $CAMonth ?>,
                            <?= $CALastMonth ?>, <?= $CAThreeLastMonth ?>,
                            <?= $CASixLastMonth ?>, <?= $CAYear ?>, <?= $CALastYear ?>,
                            <?= $CATwoLastYear ?>, <?= $CAThreeLastYear ?>,
                            <?= $CAFourLastYear ?>, <?= $CAFiveLastYear ?>
                          ]
                        }],
                        chart: {
                          type: 'bar',
                          height: 350
                        },
                        plotOptions: {
                          bar: {
                            borderRadius: 4,
                            horizontal: true,
                          }
                        },
                        dataLabels: {
                          enabled: false
                        },
                        xaxis: {
                          categories: ['Cette Journée', 'Cette Semaine', 'Ce Mois',
                            'Mois Passé', 'Trois Mois Passés',
                            'Six Mois Passés', 'Cette Année encours', 'Année Passée',
                            'Deux Années Passées', 'Trois Années Passées',
                            'Quatre Années Passées', 'Cinq Années Passées'
                          ],
                        }
                      }).render();
                    });
                  </script>
                  <!-- End Bar Chart -->

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>
  </main><!-- End #main -->
  <!-- MES DIFFERENTS MODALES -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>