<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['idA']) &&
        isset($_POST['idM'])
    ) {
        #Modif stock entrepot
        $idA = $_POST['idA'];
        $idM = $_POST['idM'];

        $sql = "SELECT * FROM approv WHERE idA = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$idA]);
        $res = $req->fetch();
        $qteA = $res['qteA'];

        // Vérification du nom d'utilisateur s'il existe déjà
        $sqlM = "SELECT * FROM medicament WHERE idM = ?";
        $reqM = $pdo->prepare($sqlM);
        $reqM->execute([$idM]);
        $resM = $reqM->fetch();
        $desMed = $resM['design'];
        $stockMed = $resM['stock'];
        $stockApprov = $stockMed - $qteA;

        $sqlInv = "SELECT * FROM invest WHERE idM = ?";
        $reqInv = $pdo->prepare($sqlInv);
        $reqInv->execute([$idM]);
        $resultatInv = $reqInv->fetch();
        $stockInv = $resultatInv['stock'];
        $stockTotInvest = $stockInv - $qteA;
        $dateOperation = date("Y-m-d");
        
        # Update des données dans la table 
        $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
        $req = $pdo->prepare($sql);
        $req->execute([$stockApprov,$idM]);

        $sqlInvest = "UPDATE invest SET `stock`=?,`dateOp`=? WHERE `idM`=?";
        $reqInvest = $pdo->prepare($sqlInvest);
        $reqInvest->execute([$stockTotInvest,$dateOperation,$idM]);
 
        //Update Approv
        $sql = "DELETE FROM approv WHERE idA=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idA]);

        $msg_erreur = "L'approvisionnement du produit ".$desMed." est supprimé avec succès";
        header("Location:../approv.php?succes=$msg_erreur");
    }else{
        $msg_erreur = "Il y a une erreure";
        header("Location:../approv.php?erreur=$msg_erreur");
        exit;
    }
?>