<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['modiVenteProformatBtn']) &&
        isset($_POST['idC']) &&
        isset($_POST['statut']) 
    ) {
        //Les variables
        $idC = $_POST['idC'];
        $statut = $_POST['statut'];

        //Update Commande
        if($statut=='Cash'){
            //Modifi Statut
            $sql1 = "UPDATE commande SET `statut`=? WHERE `idC`=?";
            $req1 = $pdo->prepare($sql1);
            $req1->execute([$statut,$idC]);

            //Modif Stock
            $sql2 = "UPDATE medicament INNER JOIN detail_commande 
            ON medicament.idM=detail_commande.idM SET `stock`=(`stock`-`qte`) 
            WHERE detail_commande.idC = ?";
            $req2 = $pdo->prepare($sql2);
            $req2->execute([$idC]);

            //Modif Caisse
            $sql3 = "SELECT SUM(prixV*qte) AS sumCA 
            FROM detail_commande WHERE idC= ?";
            $req3 = $pdo->prepare($sql3);
            $req3->execute([$idC]);
            $res3 = $req3->fetch();
            $sumCA = $res3['sumCA'];

            $sql = "INSERT INTO ca (`idDC`,`m_ca`) 
            SELECT `idDC`, (prixV*qte) 
            FROM detail_commande WHERE idC= ?";
            $req = $pdo->prepare($sql);
            $req->execute([$idC]);

            $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
            $reqRec = $pdo->prepare($sqlRec);
            $reqRec->execute([1]);
            $resRech = $reqRec->fetch();
            $ventes = $resRech['ventes'];
            $depenses = $resRech['depenses'];
            $creances = $resRech['creances'];

            $vente_actuelle = $ventes + $sumCA;
            $Net = $vente_actuelle - $depenses - $creances;

            $sql4 = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
            $req4 = $pdo->prepare($sql4);
            $req4->execute([$vente_actuelle,$Net,1]);

            //Message d'alerte
            $msg_erreur = "Statut modifié en CASH avec succès";

        }elseif($statut=='Credit'){
            //Select montantCA
            $sqlRowCount = "SELECT * FROM detail_commande INNER JOIN commande 
            ON commande.idC=detail_commande.idC INNER JOIN medicament 
            ON medicament.idM=detail_commande.idM INNER JOIN client 
            ON client.idClient = commande.idClient WHERE detail_commande.idC='$idC'";
            $rowCountRequete = $pdo->query($sqlRowCount)->rowCount();

            if($rowCountRequete>0){
                //Modifi Statut
                $sql = "UPDATE commande SET `statut`=? WHERE `idC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$statut,$idC]);

                //Select montantCA
                $sql1 = "SELECT SUM(prixV*qte) AS sumCA 
                FROM detail_commande WHERE idC= ?";
                $req1 = $pdo->prepare($sql1);
                $req1->execute([$idC]);
                $res1 = $req1->fetch();
                $sumCA = $res1['sumCA'];

                //Modif Credit Table
                $sql2 = "INSERT INTO credit (`idC`,`mCred`,`etatCred`) VALUES (?,?,?)";
                $req2 = $pdo->prepare($sql2);
                $req2->execute([$idC,$sumCA,0]);

                //Modif Stock
                $sql3 = "UPDATE medicament INNER JOIN detail_commande 
                ON medicament.idM=detail_commande.idM SET `stock`=(`stock`-`qte`) 
                WHERE detail_commande.idC = ?";
                $req3 = $pdo->prepare($sql3);
                $req3->execute([$idC]);

                //Modif Caisse
                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];
                $creances_actuelle = $creances + $sumCA;
                $Net = $ventes - $depenses - $creances_actuelle;

                $sql4 = "UPDATE caisse SET `creances`=? , `net`= ? WHERE `idCaisse`=?";
                $req4 = $pdo->prepare($sql4);
                $req4->execute([$creances_actuelle,$Net,1]);

                //Message d'alerte
                $msg_erreur = "Statut modifié CREDIT avec succès";
            }else{
                $msg_erreur = "Cette facture proformat, ne contient pas des données.";
            }
        }else{
            $msg_erreur = "Etat Initial du Statut de la commande";
        }

        header("Location:../ventes.php?succes=$msg_erreur");

    }elseif (
        isset($_POST['modiVenteCashBtn']) &&
        isset($_POST['idC']) &&
        isset($_POST['statut']) 
    ) {
        //Les variables
        $idC = $_POST['idC'];
        $statut = $_POST['statut'];

        //Update Commande
        if($statut=='Proformat'){
            //Select montantCA
            $sqlRowCount = "SELECT * FROM detail_commande INNER JOIN commande 
            ON commande.idC=detail_commande.idC INNER JOIN medicament 
            ON medicament.idM=detail_commande.idM INNER JOIN client 
            ON client.idClient = commande.idClient WHERE detail_commande.idC='$idC'";
            $rowCountRequete = $pdo->query($sqlRowCount)->rowCount();
            if($rowCountRequete>0){
                //Modifi Statut
                $sql1 = "UPDATE commande SET `statut`=? WHERE `idC`=?";
                $req1 = $pdo->prepare($sql1);
                $req1->execute([$statut,$idC]);

                //Modif Stock
                $sql2 = "UPDATE medicament INNER JOIN detail_commande 
                ON medicament.idM=detail_commande.idM SET `stock`=(`stock`+`qte`) 
                WHERE detail_commande.idC = ?";
                $req2 = $pdo->prepare($sql2);
                $req2->execute([$idC]);

                //Modif Caisse
                $sql3 = "SELECT SUM(prixV*qte) AS sumCA 
                FROM detail_commande WHERE idC= ?";
                $req3 = $pdo->prepare($sql3);
                $req3->execute([$idC]);
                $res3 = $req3->fetch();
                $sumCA = $res3['sumCA'];

                #Modif Caisse
                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $vente_actuelle = $ventes - $sumCA;
                $Net = $vente_actuelle - $depenses - $creances;

                $sql4 = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
                $req4 = $pdo->prepare($sql4);
                $req4->execute([$vente_actuelle,$Net,1]);

                //Modif CA
                $sql = "DELETE detail_commande,ca FROM ca INNER JOIN detail_commande
                ON detail_commande.idDC=ca.idDC WHERE detail_commande.idC= ?";
                $req = $pdo->prepare($sql);
                $req->execute([$idC]);

                //Message d'alerte
                $msg_erreur = "Statut modifié en PROFORMAT avec succès";
            }else{
                $msg_erreur = "Cette facture cash, ne contient pas des données.";
            }
        }elseif($statut=='Credit'){
            //Select montantCA
            $sqlRowCount = "SELECT * FROM detail_commande INNER JOIN commande 
            ON commande.idC=detail_commande.idC INNER JOIN medicament 
            ON medicament.idM=detail_commande.idM INNER JOIN client 
            ON client.idClient = commande.idClient WHERE detail_commande.idC='$idC'";
            $rowCountRequete = $pdo->query($sqlRowCount)->rowCount();

            if($rowCountRequete>0){
                //Modifi Statut
                $sql = "UPDATE commande SET `statut`=? WHERE `idC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$statut,$idC]);

                //Select montantCA
                $sql1 = "SELECT SUM(prixV*qte) AS sumCA 
                FROM detail_commande WHERE idC= ?";
                $req1 = $pdo->prepare($sql1);
                $req1->execute([$idC]);
                $res1 = $req1->fetch();
                $sumCA = $res1['sumCA'];

                //Modif Credit Table
                $sql2 = "INSERT INTO credit (`idC`,`mCred`,`etatCred`) VALUES (?,?,?)";
                $req2 = $pdo->prepare($sql2);
                $req2->execute([$idC,$sumCA,0]);

                //Modif Caisse
                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $creances_actuelle = $creances + $sumCA;
                $Net = $ventes - $depenses - $creances_actuelle;

                $sql4 = "UPDATE caisse SET `creances`=? , `net`= ? WHERE `idCaisse`=?";
                $req4 = $pdo->prepare($sql4);
                $req4->execute([$creances_actuelle,$Net,1]);

                //Message d'alerte
                $msg_erreur = "Statut modifié CREDIT avec succès";
            }else{
                $msg_erreur = "Cette facture cash, ne contient pas des données.";
            }
        }else{
            $msg_erreur = "Etat Initial du Statut de la commande";
        }
        header("Location:../ventes.php?succes=$msg_erreur");

    }
?>