<?php
session_start();
require_once('../../include/connexiondb.php');

// Fonction pour insérer ou mettre à jour les données d'un élève dans la table spécifiée
function insertOrUpdateCotes($pdo, $tableName, $idI, $idCours, $data) {
    // Vérifier si l'enregistrement existe déjà
    $query = "SELECT * FROM $tableName WHERE idI = :idI AND idCours = :idCours";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':idCours', $idCours, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        // L'enregistrement existe, effectuer une mise à jour
        $updateQuery = "UPDATE $tableName SET ";
        foreach ($data as $key => $value) {
            $updateQuery .= "$key = :$key, ";
        }
        $updateQuery = rtrim($updateQuery, ", ");
        $updateQuery .= " WHERE idI = :idI AND idCours = :idCours";

        $stmt = $pdo->prepare($updateQuery);

        foreach ($data as $key => $value) {
            $stmt->bindParam(":$key", $data[$key], PDO::PARAM_STR);
        }
        
        // Ajouter les paramètres idI et idCours pour la clause WHERE
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idCours', $idCours, PDO::PARAM_INT);

        return $stmt->execute();
    } else {
        // L'enregistrement n'existe pas, effectuer une insertion
        $columns = implode(", ", array_keys($data));
        $values = implode(", ", array_map(function ($key) {
            return ":$key";
        }, array_keys($data)));

        $insertQuery = "INSERT INTO $tableName (idI, idCours, $columns) VALUES (:idI, :idCours, $values)";

        $stmt = $pdo->prepare($insertQuery);
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idCours', $idCours, PDO::PARAM_INT);

        foreach ($data as $key => &$value) {
            $stmt->bindParam(":$key", $value, PDO::PARAM_STR);
        }
        
        return $stmt->execute();
    }
}

// Soumission du formulaire
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['idCours']) && isset($_POST['idC'])) {
        $idCours = $_POST['idCours'];
        $idC = $_POST['idC'];

        // Récuperation de la section
        $requestSection="SELECT * FROM t_classe WHERE idC='$idC'";
        $stmSection=$pdo->query($requestSection)->fetch();
        $sectionClasse = $stmSection['sec'];

        // Récupération maxPer et maxEx 
        $requestMaxCours="SELECT * FROM t_cours WHERE idCours='$idCours'";
        $stmMaxCours=$pdo->query($requestMaxCours)->fetch();
        $rsmaxP = $stmMaxCours['maxPer'];
        $rsmaxE = $stmMaxCours['maxEx'];

        // Récupérer le nombre d'élèves par classe et année
        $sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
        $reqPgrh = $pdo->prepare($sqlPgrh);
        $reqPgrh->execute([1]); 
        $resPgrh = $reqPgrh->fetch();
        $annee = $resPgrh['idAn'];

        $numStudents=$pdo->query("SELECT * FROM t_inscrit
         WHERE idC='$idC' And idA='$annee'")->rowCount();

        for ($i = 1; $i <= $numStudents; $i++) {
            $idI = $_POST["idI_$i"];
            
            // Appeler la fonction pour insérer ou mettre à jour
            if ($sectionClasse == "Maternelle") {
                // Les champs sont des notes
                $data1 = array(
                    'coteP1' => ($_POST["p1_$i"]=='' || $_POST["p1_$i"] > $rsmaxP) ? NULL : $_POST["p1_$i"],
                    'coteP2' => ($_POST["p2_$i"]=='' || $_POST["p2_$i"] > $rsmaxP) ? NULL : $_POST["p2_$i"],
                    'coteP3' => ($_POST["p3_$i"]=='' || $_POST["p3_$i"] > $rsmaxP) ? NULL : $_POST["p3_$i"],
                );
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateCotes($pdo, 't_cote_mat', $idI, $idCours, $data1);
            } elseif ($sectionClasse == "Primaire") {
                // Les champs sont des notes
                $data2 = array(
                    'coteP1' => ($_POST["p1_$i"]=='' || $_POST["p1_$i"] > $rsmaxP) ? NULL : $_POST["p1_$i"],
                    'coteP2' => ($_POST["p2_$i"]=='' || $_POST["p2_$i"] > $rsmaxP) ? NULL : $_POST["p2_$i"],
                    'coteEx1' => ($_POST["ex1_$i"]=='' || $_POST["ex1_$i"] > $rsmaxE) ? NULL : $_POST["ex1_$i"],
                    'coteP3' => ($_POST["p3_$i"]=='' || $_POST["p3_$i"] > $rsmaxP) ? NULL : $_POST["p3_$i"],
                    'coteP4' => ($_POST["p4_$i"]=='' || $_POST["p4_$i"] > $rsmaxP) ? NULL : $_POST["p4_$i"],
                    'coteEx2' => ($_POST["ex2_$i"]=='' || $_POST["ex2_$i"] > $rsmaxE) ? NULL : $_POST["ex2_$i"],
                    'coteP5' => ($_POST["p5_$i"]=='' || $_POST["p5_$i"] > $rsmaxP) ? NULL : $_POST["p5_$i"],
                    'coteP6' => ($_POST["p6_$i"]=='' || $_POST["p6_$i"] > $rsmaxP) ? NULL : $_POST["p6_$i"],
                    'coteEx3' => ($_POST["ex3_$i"]=='' || $_POST["ex3_$i"] > $rsmaxE) ? NULL : $_POST["ex3_$i"],
                );
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateCotes($pdo, 't_cote_pri', $idI, $idCours, $data2);
            } elseif ($sectionClasse == "Secondaire") {
                // Les champs sont des notes
                $data3 = array(
                    'coteP1' => ($_POST["p1_$i"]=='' || $_POST["p1_$i"] > $rsmaxP) ? NULL : $_POST["p1_$i"],
                    'coteP2' => ($_POST["p2_$i"]=='' || $_POST["p2_$i"] > $rsmaxP) ? NULL : $_POST["p2_$i"],
                    'coteEx1' => ($_POST["ex1_$i"]=='' || $_POST["ex1_$i"] > $rsmaxE) ? NULL : $_POST["ex1_$i"],
                    'coteP3' => ($_POST["p3_$i"]=='' || $_POST["p3_$i"] > $rsmaxP) ? NULL : $_POST["p3_$i"],
                    'coteP4' => ($_POST["p4_$i"]=='' || $_POST["p4_$i"] > $rsmaxP) ? NULL : $_POST["p4_$i"],
                    'coteEx2' => ($_POST["ex2_$i"]=='' || $_POST["ex2_$i"] > $rsmaxE) ? NULL : $_POST["ex2_$i"],
                );
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateCotes($pdo, 't_cote_sec', $idI, $idCours, $data3);
            }
        }
        
        // Rediriger ou afficher un message de confirmation après l'enregistrement/mise à jour
        $msg_erreur = "Fiche de côtes initialisée avec succès";
        header("Location:../cotation.php?succes=$msg_erreur"); 

    }else {
        $msg_erreur = "Il y a une erreur lors de l'initialisation de la Fiche de côtes.";
        header("Location:../cotation.php?erreur=$msg_erreur");  
    }
}
?>