
<?php

function getClasseByJury($pdo)
{
    $idJ = $_SESSION['id'];
    $sql = $pdo->prepare("SELECT COUNT(DISTINCT t_classe.idC) AS nombreClasse
        FROM t_inscrit
        INNER JOIN t_classe ON t_classe.idC = t_inscrit.idC
        INNER JOIN t_cours ON t_classe.idC = t_cours.idC
        INNER JOIN t_ens ON t_ens.idEns = t_cours.idEns
        WHERE t_ens.idEns = :idJ");
    $sql->bindParam(':idJ', $idJ, PDO::PARAM_INT);
    $sql->execute();

    $data = $sql->fetch(PDO::FETCH_ASSOC);

    // Retourne le nombre d'élèves
    return $data['nombreClasse'];
}
 
function getCoursByJury($pdo)
{
    $idJ = $_SESSION['id'];
    $sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
    $reqPgrh = $pdo->prepare($sqlPgrh);
    $reqPgrh->execute([1]);
    $resPgrh = $reqPgrh->fetch();
    $ResultmaxAS = $resPgrh['idAn'];
    $sql = $pdo->prepare("SELECT COUNT(DISTINCT t_cours.idCours) AS nombreCours
        FROM t_inscrit
        INNER JOIN t_classe ON t_classe.idC = t_inscrit.idC
        INNER JOIN t_cours ON t_classe.idC = t_cours.idC
        INNER JOIN t_ens ON t_ens.idEns = t_cours.idEns
        WHERE t_ens.idEns = :idJ AND t_cours.idA=:idA");
    $sql->bindParam(':idJ', $idJ, PDO::PARAM_INT);
    $sql->bindParam(':idA', $ResultmaxAS, PDO::PARAM_INT);
    $sql->execute();

    $data = $sql->fetch(PDO::FETCH_ASSOC);

    // Retourne le nombre d'élèves
    return $data['nombreCours'];
}

function getEleveByJury($pdo)
{
    $idJ = $_SESSION['id'];
    $sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
    $reqPgrh = $pdo->prepare($sqlPgrh);
    $reqPgrh->execute([1]);
    $resPgrh = $reqPgrh->fetch();
    $ResultmaxAS = $resPgrh['idAn'];
    $sql = $pdo->prepare("SELECT COUNT(DISTINCT t_inscrit.idI) AS nombreEleves
        FROM t_inscrit
        INNER JOIN t_classe ON t_classe.idC = t_inscrit.idC
        INNER JOIN t_cours ON t_classe.idC = t_cours.idC
        INNER JOIN t_ens ON t_ens.idEns = t_cours.idEns
        WHERE t_ens.idEns = :idJ AND t_inscrit.idA=:idA");
    $sql->bindParam(':idJ', $idJ, PDO::PARAM_INT);
    $sql->bindParam(':idA', $ResultmaxAS, PDO::PARAM_INT);
    $sql->execute();

    $data = $sql->fetch(PDO::FETCH_ASSOC);

    // Retourne le nombre d'élèves
    return $data['nombreEleves'];
}