<?php
session_start();
if (!isset($_SESSION["login"])) {
  header('Location:../index.php');
}
require_once('../include/connexiondb.php');
require_once('php_include/some_fonctions.php');
?>

<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent2.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="ld.php">
          <i class="bi bi-slack"></i>
          <span>Prévision budgetaire</span>
        </a>
      </li><!-- End Classe Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="rec.php">
          <i class="bi bi-slack"></i>
          <span>Recouvrement</span>
        </a>
      </li><!-- End Classe Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Tableau de bord</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Acceuil</a></li>
          <li class="breadcrumb-item active">Tableau de bord</li>
        </ol>
      </nav>
      <!-- LECTURE D'ERREUR -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">

        <!-- Left side columns -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Agent Card -->
            <div class="col-xxl-6 col-md-6">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Budget prévisionnel<span> | Annuel</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-3">
                      <h6> <?=getBP($pdo)?> $</h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Budget prévisionnel</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Agent Card -->

            <!-- Mat Card -->
            <div class="col-xxl-6 col-md-6">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Dépenses deja effectuées <span>| Toutes</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?=getDE($pdo)?> $</h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Dépenses deja effectuées</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Mat Card -->

            <!-- Mat Card -->
            <div class="col-xxl-6 col-md-6">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Ecart <span>| global</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getBP($pdo)-getDE($pdo) ?> $</h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Ecart global</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Mat Card -->

            <!-- Prim Card -->
            <div class="col-xxl-6 col-md-6">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Suivi en pourcentage <span>| Général</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getBP($pdo) ? round((getDE($pdo) / getBP($pdo)) * 100, 2) : 0 ?> %</h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Suivi en pourcentage</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End prim Card -->
            
          </div>
        </div><!-- End Left side columns -->

      </div>
    </section>

  </main><!-- End #main -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>