<?php
session_start();
require_once('../../include/connexiondb.php');

if (
    isset($_POST['addTFBtn']) &&
    isset($_POST['idC']) &&
    isset($_POST['idA']) &&
    isset($_POST['catTF']) &&
    isset($_POST['designTF']) &&
    isset($_POST['montTF'])
) {
    //Les variables
    $idC = $_POST['idC'];
    $idA = $_POST['idA'];
    $catTF = $_POST['catTF'];
    $designTF = $_POST['designTF'];
    $montTF = $_POST['montTF'];

    if (is_numeric($montTF)) {
        // Mon algo
        $sqlRec = "SELECT * FROM t_typeFrais WHERE catTF = ? 
            AND designTF = ? AND idC = ? AND idA = ?";
        $reqRec = $pdo->prepare($sqlRec);
        $reqRec->execute([$catTF, $designTF, $idC, $idA]);
        $resRech = $reqRec->rowCount();

        if ($resRech > 0) {
            $msg_erreur = "Ce type de frais existe deja dans cette classe";
            header("Location:../listeFraisByClasse.php?erreur=$msg_erreur&classe=$idC");
            exit;
        } else {
            # Update des données dans la table 
            $sql = "INSERT INTO t_typeFrais (`idA`,`idC`,`catTF`,`designTF`,`montTF`)
                VALUES(?,?,?,?,?)";
            $req = $pdo->prepare($sql);
            $req->execute([$idA, $idC, $catTF, $designTF, $montTF]);

            #Message de succès
            $msg_erreur = "Type de frais enregistré avec succès";
            header("Location:../listeFraisByClasse.php?succes=$msg_erreur&classe=$idC");
        }
    } else {
        $msg_erreur = "Le champ montant doit être en numérique";
        header("Location:../listeFraisByClasse.php?erreur=$msg_erreur&classe=$idC");
        exit;
    }
} else {
    $msg_erreur = "Il y a une erreure";
    header("Location:../listeFraisByClasse.php?erreur=$msg_erreur&classe=$idC");
    exit;
}
