<?php 
session_start();
if(!isset($_SESSION["login"]) && !isset($_SESSION['etat'])){
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 3;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord="SELECT count(*) AS total_records FROM agent INNER JOIN salaire
ON salaire.idA=agent.idA where nomA like '%$des%'";
$total_records=$pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1; 

$requete="SELECT * FROM agent INNER JOIN salaire
ON salaire.idA=agent.idA where nomA like '%$des%'
ORDER BY nomA ASC LIMIT $offset, $total_records_per_page";
$resultat=$pdo->query($requete);

//Paramettres GRH
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$indem = $resPgrh['indem'];
?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
   <aside id="sidebar" class="sidebar">

    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="agent.php">
        <i class="bi bi-person-rolodex"></i>
          <span>Agents</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="pres.php">
        <i class="bi bi-person-rolodex"></i>
          <span>Présences</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="conge.php">
        <i class="bi bi-person-rolodex"></i>
          <span>Congés</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="avance.php">
        <i class="bi bi-currency-exchange"></i>
          <span>Avances</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link " href="salaire.php">
        <i class="bi bi-currency-exchange"></i>
          <span>Paiements</span>
        </a>
      </li><!-- End ventes Page Nav -->
    </ul>

  </aside><!-- End Sidebar-->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Salaires</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Salaires</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
        <div class="alert alert-warning" role="alert">
          <?php echo htmlspecialchars($_GET['erreur']); ?>
        </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
        <div class="alert alert-success" role="alert">
          <?php echo htmlspecialchars($_GET['succes']); ?>
        </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Journal des paiements des employés <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddSalaire" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a>
                  | <a data-bs-toggle="modal" data-bs-target="#modalPrintSalaire" class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER</a>
                  </span></h5>

                  <form method="get" action="salaire.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit" ></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">AGENT</th>
                        <th scope="col">SB</th>
                        <th scope="col">AVT</th>
                        <th scope="col">RTN</th>
                        <th scope="col">AVN</th>
                        <th scope="col">IMP</th>
                        <th scope="col">NET</th>
                        <th scope="col">JOUR</th>
                        <th scope="col">MOIS</th>
                        <th scope="col">ANNEE</th>
                        <th scope="col">DATE</th>
                        <th scope="col">ACTIONS</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1; while($data=$resultat->fetch()){ ?>
                        <tr>
                          <th scope="row"><?=$number?></th>
                          <td><?php echo $data['nomA']?></td>
                          <td class="text-success">+<?php echo $data['salA']?></td>
                          <td class="text-success">+<?php echo $indem?></td>
                          <td class="text-danger">-<?php echo $data['retN']?></td>
                          <td class="text-danger">-<?php echo $data['avN']?></td>
                          <td class="text-danger">-<?php echo $data['imp']?></td>
                          <td class="text-success"><strong><?php echo $data['netS']?> $</strong></td>
                          <td><?php echo $data['jour']?></td>
                          <td><?php echo $data['mS']?></td>
                          <td><?php echo $data['aS']?></td>
                          <td><?php echo date('d-m-Y', strtotime($data['dateS']))?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintBultin<?php echo $data['idS']?>" class="btn btn-info"><span class="bi bi-printer-fill"></span> </a>
                          </td>
                        </tr>
                      <?php $number++; include('modal_include/ModalmodifierPersonnel.php'); } ?> 
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                        echo "class=' page-item disabled'";
                      } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                        echo "href='salaire.php?page_no=$previous_page&des=$des'";
                                      } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='salaire.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='salaire.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                        echo "class='disabled page-item'";
                      } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                          echo "href='salaire.php?page_no=$next_page'"; } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='salaire.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    } ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

  <!-- MODAL ADD Agent -->
  <div class="modal fade" id="modalAddSalaire" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter un paiement</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_personnel/addSalaire.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Agent</label>
                <select class="form-select" name="idA" id="example-search">
                  <?php
                  $requeteAg = "select * from agent  where etatA='En service'";
                  $resultatAg = $pdo->query($requeteAg);
                  while ($result = $resultatAg->fetch()) { ?>
                    <option value="<?php echo $result['idA']; ?>">
                      <?php echo $result['nomA'] ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Logement</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-currency-exchange"></i></span>
                  <input type="text" name="logem" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le Montant SVP !</div>
                </div>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Transport</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-currency-exchange"></i></span>
                  <input type="text" name="trans" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le Montant SVP !</div>
                </div>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Prime</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-currency-exchange"></i></span>
                  <input type="text" name="prime" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le Montant SVP !</div>
                </div>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Mois de paiement</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-calendar-month"></i></span>
                  <select name="mS" class="form-select" id="titre" required>
                    <option value="Janvier">Janvier</option>
                    <option value="Février">Février</option>
                    <option value="Mars">Mars</option>
                    <option value="Avril">Avril</option>
                    <option value="Mai">Mai</option>
                    <option value="Juin">Juin</option>
                    <option value="Juillet">Juillet</option>
                    <option value="Août">Août</option>
                    <option value="Septembre">Septembre</option>
                    <option value="Octobre">Octobre</option>
                    <option value="Novembre">Novembre</option>
                    <option value="Décembre">Décembre</option>
                  </select>
                  <div class="invalid-feedback">Veillez choisir le mois SVP !</div>
                </div>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Année de paiement</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-calendar"></i></span>
                  <select name="aS" class="form-select" id="titre" required>
                    <?php
                    $currentYear = date("Y");
                    $futureYearsCount = 10;

                    for ($i = 0; $i < $futureYearsCount; $i++) {
                      $year = $currentYear + $i;
                      echo '<option value="' . $year . '">' . $year . '</option>' . PHP_EOL;
                    }
                    ?>
                  </select>
                  <div class="invalid-feedback">Veillez choisir l'année SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addSalaireBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD CLIENT-->

  <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalPrintSalaire" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Listing de paie</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="../include/listeSalaire.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">

            <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Mois de paiement</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-calendar-month"></i></span>
                  <select name="mS" class="form-select" id="titre" required>
                    <option value="Janvier">Janvier</option>
                    <option value="Février">Février</option>
                    <option value="Mars">Mars</option>
                    <option value="Avril">Avril</option>
                    <option value="Mai">Mai</option>
                    <option value="Juin">Juin</option>
                    <option value="Juillet">Juillet</option>
                    <option value="Août">Août</option>
                    <option value="Septembre">Septembre</option>
                    <option value="Octobre">Octobre</option>
                    <option value="Novembre">Novembre</option>
                    <option value="Décembre">Décembre</option>
                  </select>
                  <div class="invalid-feedback">Veillez choisir le mois SVP !</div>
                </div>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Année de paiement</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-calendar"></i></span>
                  <select name="aS" class="form-select" id="titre" required>
                  <?php
                    $requeteAg = "SELECT DISTINCT `aS` FROM salaire";
                    $resultatAg = $pdo->query($requeteAg);
                    while ($result = $resultatAg->fetch()) { ?>
                      <option value="<?php echo $result['aS']; ?>">
                        <?php echo $result['aS'] ?>
                      </option>
                  <?php } ?>
                  </select>
                  <div class="invalid-feedback">Veillez choisir l'année SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="printPresBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>