<?php
session_start();
if (!isset($_SESSION["login"])) {
  header('Location:../index.php');
}
require_once('../include/connexiondb.php');
require_once('../include/fonctionPrint.php');
$idC = $_SESSION['idC'];
$idUser = $_SESSION['idJ'];

$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$annee = $resPgrh['idAn'];

$rqt = "SELECT *
FROM t_classe INNER JOIN t_option ON t_classe.idO = t_option.idO
WHERE t_classe.idC = '$idC'";
$setClasse = $pdo->query($rqt)->fetch();
$classeEl = $setClasse['design'] . ' ' . $setClasse['designO'] . ' ' . $setClasse['ord'];

$requeteInscrit = "SELECT * FROM t_inscrit WHERE idC = '$idC' AND idA = '$annee'";
$resultatInscrit = $pdo->query($requeteInscrit);

$requeteClasse = "SELECT * FROM t_classe WHERE idC = '$idC'";
$resultatClasse = $pdo->query($requeteClasse)->fetch();
$sectionClasse = $resultatClasse['sec'];
?>

<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent2.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link" href="classe.php">
          <i class="bi bi-house"></i>
          <span>Classes</span>
        </a>
      </li><!-- End Dashboard Nav -->
    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Gestion d'une classe ::: <?= $classeEl ?></h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Acceuil</a></li>
          <li class="breadcrumb-item active">Classes</li>
        </ol>
      </nav>
      <!-- LECTURE D'ERREUR -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Décision du jury</h5>

                  <?php if ($sectionClasse == "Maternelle") { ?>
                    <form action="php_include/addDecision.php" method="post">
                      <table class="table table-bordered">
                        <thead>
                          <th scope="col">#</th>
                          <th scope="col">Elève</th>
                          <th scope="col">Pourcentage</th>
                          <th scope="col">Décision</th>
                          <th scope="col">Année</th>
                          <th scope="col">Classe</th>
                        </thead>
                        <tbody>
                          <?php $i = 1;
                          while ($data = $resultatInscrit->fetch()) {
                            // Recuperation des conduites
                            $idIns = $data['idI'];
                            //Mes totaux
                            $totalCote1 = getTotCotePerMat($pdo, $idIns, $annee, 'P1');
                            $totalCote2 = getTotCotePerMat($pdo, $idIns, $annee, 'P2');
                            $totalCote3 = getTotCotePerMat($pdo, $idIns, $annee, 'P3');
                            $totalMaxPer = getTotCoteMaxMat($pdo, $idIns, $annee);
                            //Pourcentage
                            $pourc = round((($totalCote1 + $totalCote2 + $totalCote3) / ($totalMaxPer * 3)) * 100, 2);
                            //T_decision
                            $requeteDecision = "SELECT * FROM t_decision WHERE idI = '$idIns'
                            AND decJury='En cours de traitement' AND idA = '$annee'";
                            $resDec = $pdo->query($requeteDecision)->fetch();
                          ?>

                            <tr>
                              <th scope="row"><?= $i ?></th>
                              <td><input type="hidden" value="<?= $idIns ?>" name="idI_<?= $i ?>">
                                <input type="hidden" value="<?= $data['numMat'] ?>" name="numMat_<?= $i ?>">
                                <input type="hidden" value="<?= $idC ?>" name="idClasse">
                                <input type="hidden" value="<?= $annee ?>" name="idAnnee">
                                <input type="hidden" value="<?= $pourc ?>" name="pourc_<?= $i ?>">
                                <?php echo $data['nom'] ?>
                              </td>
                              <td><?php echo $pourc ?> %</td>
                              <?php if ($pdo->query($requeteDecision)->rowCount() <= 0) { ?>
                                <td><select name="decJury_<?= $i ?>" class="form-select">
                                    <option disabled>Sélectionnez une décision</option>
                                    <option value="En cours de traitement">En cours de traitement</option>
                                    <option value="Monte la classe">Monte la classe</option>
                                    <option value="Double la classe">Double la classe</option>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idC_<?= $i ?>">
                                    <option disabled>Sélectionnez une classe</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_classe INNER JOIN t_option
                                     ON t_option.idO=t_classe.idO order by design asc";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idC']; ?>" <?php if ($result['idC'] === $idC) echo "Selected" ?>>
                                        <?php echo $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idA_<?= $i ?>">
                                    <option disabled>Sélectionnez une année</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_an";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idA']; ?>" <?php if ($result['idA'] === $annee) echo "Selected" ?>>
                                        <?php echo $result['designA'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                              <?php } else { ?>
                                <td><select name="decJury_<?= $i ?>" class="form-select">
                                    <option disabled>Sélectionnez une décision</option>
                                    <option value="En cours de traitement" <?php if ($resDec['decJury'] === 'En cours de traitement') echo "Selected" ?>>En cours de traitement</option>
                                    <option value="Monte la classe" <?php if ($resDec['decJury'] === 'Monte la classe') echo "Selected" ?>>Monte la classe</option>
                                    <option value="Double la classe" <?php if ($resDec['decJury'] === 'Double la classe') echo "Selected" ?>>Double la classe</option>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idC_<?= $i ?>">
                                    <option disabled>Sélectionnez une classe</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_classe INNER JOIN t_option
                                     ON t_option.idO=t_classe.idO order by design asc";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idC']; ?>" <?php if ($result['idC'] === $resDec['idC']) echo "Selected" ?>>
                                        <?php echo $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idA_<?= $i ?>">
                                    <option disabled>Sélectionnez une année</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_an";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idA']; ?>" <?php if ($result['idA'] === $resDec['idA']) echo "Selected" ?>>
                                        <?php echo $result['designA'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                              <?php } ?>
                            </tr>
                          <?php $i++;
                          } ?>
                        </tbody>
                      </table>
                      <a href="menuJury.php" class="btnModClose">Retourner</a>
                      <button type="submit" name="addOpBtn" class="btnModSave">Enregistrer</button>
                    </form>
                  <?php } elseif ($sectionClasse == "Primaire") { ?>
                    <form action="php_include/addDecision.php" method="post">
                      <table class="table table-bordered">
                        <thead>
                          <th scope="col">#</th>
                          <th scope="col">Elève</th>
                          <th scope="col">Pourcentage</th>
                          <th scope="col">Décision</th>
                          <th scope="col">Année</th>
                          <th scope="col">Classe</th>
                        </thead>
                        <tbody>
                          <?php $i = 1;
                          while ($data = $resultatInscrit->fetch()) {
                            // Recuperation des conduites
                            $idIns = $data['idI'];
                            //Mes totaux
                            $totalCote1 = getTotCotePerPri($pdo,$idIns,$annee,'P1');
                            $totalCote2 = getTotCotePerPri($pdo,$idIns,$annee,'P2');
                            $totalCote3 = getTotCotePerPri($pdo,$idIns,$annee,'Ex1');
                            $totalCote4 = getTotCotePerPri($pdo,$idIns,$annee,'P3');
                            $totalCote5 = getTotCotePerPri($pdo,$idIns,$annee,'P4');
                            $totalCote6 = getTotCotePerPri($pdo,$idIns,$annee,'Ex2');
                            $totalCote7 = getTotCotePerPri($pdo,$idIns,$annee,'P5');
                            $totalCote8 = getTotCotePerPri($pdo,$idIns,$annee,'P6');
                            $totalCote9 = getTotCotePerPri($pdo,$idIns,$annee,'Ex3');
                            $totalMaxPer = getTotCoteMaxPri($pdo,$idIns,$annee);
                            $totalMaxEx = getTotExMaxPri($pdo,$idIns,$annee);
                            //Pourcentage
                            $pourc = round((($totalCote1+$totalCote2+$totalCote3+$totalCote4+$totalCote5+$totalCote6+$totalCote7+$totalCote8+$totalCote9)/(($totalMaxPer*2+$totalMaxEx)*3)) * 100, 2);
                            //T_decision
                            $requeteDecision = "SELECT * FROM t_decision WHERE idI = '$idIns'
                            AND decJury='En cours de traitement' AND idA = '$annee'";
                            $resDec = $pdo->query($requeteDecision)->fetch();
                          ?>

                            <tr>
                              <th scope="row"><?= $i ?></th>
                              <td><input type="hidden" value="<?= $idIns ?>" name="idI_<?= $i ?>">
                                <input type="hidden" value="<?= $data['numMat'] ?>" name="numMat_<?= $i ?>">
                                <input type="hidden" value="<?= $idC ?>" name="idClasse">
                                <input type="hidden" value="<?= $annee ?>" name="idAnnee">
                                <input type="hidden" value="<?= $pourc ?>" name="pourc_<?= $i ?>">
                                <?php echo $data['nom'] ?>
                              </td>
                              <td><?php echo $pourc ?> %</td>
                              <?php if ($pdo->query($requeteDecision)->rowCount() <= 0) { ?>
                                <td><select name="decJury_<?= $i ?>" class="form-select">
                                    <option disabled>Sélectionnez une décision</option>
                                    <option value="En cours de traitement">En cours de traitement</option>
                                    <option value="Monte la classe">Monte la classe</option>
                                    <option value="Double la classe">Double la classe</option>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idC_<?= $i ?>">
                                    <option disabled>Sélectionnez une classe</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_classe INNER JOIN t_option
                                     ON t_option.idO=t_classe.idO order by design asc";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idC']; ?>" <?php if ($result['idC'] === $idC) echo "Selected" ?>>
                                        <?php echo $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idA_<?= $i ?>">
                                    <option disabled>Sélectionnez une année</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_an";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idA']; ?>" <?php if ($result['idA'] === $annee) echo "Selected" ?>>
                                        <?php echo $result['designA'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                              <?php } else { ?>
                                <td><select name="decJury_<?= $i ?>" class="form-select">
                                    <option disabled>Sélectionnez une décision</option>
                                    <option value="En cours de traitement" <?php if ($resDec['decJury'] === 'En cours de traitement') echo "Selected" ?>>En cours de traitement</option>
                                    <option value="Monte la classe" <?php if ($resDec['decJury'] === 'Monte la classe') echo "Selected" ?>>Monte la classe</option>
                                    <option value="Double la classe" <?php if ($resDec['decJury'] === 'Double la classe') echo "Selected" ?>>Double la classe</option>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idC_<?= $i ?>">
                                    <option disabled>Sélectionnez une classe</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_classe INNER JOIN t_option
                                     ON t_option.idO=t_classe.idO order by design asc";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idC']; ?>" <?php if ($result['idC'] === $resDec['idC']) echo "Selected" ?>>
                                        <?php echo $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idA_<?= $i ?>">
                                    <option disabled>Sélectionnez une année</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_an";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idA']; ?>" <?php if ($result['idA'] === $resDec['idA']) echo "Selected" ?>>
                                        <?php echo $result['designA'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                              <?php } ?>
                            </tr>
                          <?php $i++;
                          } ?>
                        </tbody>
                      </table>
                      <a href="menuJury.php" class="btnModClose">Retourner</a>
                      <button type="submit" name="addOpBtn" class="btnModSave">Enregistrer</button>
                    </form>
                  <?php } elseif ($sectionClasse == "Secondaire") { ?>
                    <form action="php_include/addDecision.php" method="post">
                      <table class="table table-bordered">
                        <thead>
                          <th scope="col">#</th>
                          <th scope="col">Elève</th>
                          <th scope="col">Pourcentage</th>
                          <th scope="col">Décision</th>
                          <th scope="col">Année</th>
                          <th scope="col">Classe</th>
                        </thead>
                        <tbody>
                          <?php $i = 1;
                          while ($data = $resultatInscrit->fetch()) {
                            // Recuperation des conduites
                            $idIns = $data['idI'];
                            //Mes totaux
                            $totalCote1 = getTotCotePerSec($pdo, $idIns, $annee, 'P1');
                            $totalCote2 = getTotCotePerSec($pdo, $idIns, $annee, 'P2');
                            $totalCote3 = getTotCotePerSec($pdo, $idIns, $annee, 'Ex1');
                            $totalCote4 = getTotCotePerSec($pdo, $idIns, $annee, 'P3');
                            $totalCote5 = getTotCotePerSec($pdo, $idIns, $annee, 'P4');
                            $totalCote6 = getTotCotePerSec($pdo, $idIns, $annee, 'Ex2');
                            $totalMaxPer = getTotCoteMaxSec($pdo, $idIns, $annee);
                            $totalMaxEx = getTotExMaxSec($pdo, $idIns, $annee);
                            //Pourcentage
                            $pourc = round((($totalCote1 + $totalCote2 + $totalCote3 + $totalCote4 + $totalCote5 + $totalCote6) / (($totalMaxPer * 2 + $totalMaxEx) * 2)) * 100, 2);
                            //T_decision
                            $requeteDecision = "SELECT * FROM t_decision WHERE idI = '$idIns'
                            AND decJury='En cours de traitement' AND idA = '$annee'";
                            $resDec = $pdo->query($requeteDecision)->fetch();
                          ?>

                            <tr>
                              <th scope="row"><?= $i ?></th>
                              <td><input type="hidden" value="<?= $idIns ?>" name="idI_<?= $i ?>">
                                <input type="hidden" value="<?= $data['numMat'] ?>" name="numMat_<?= $i ?>">
                                <input type="hidden" value="<?= $idC ?>" name="idClasse">
                                <input type="hidden" value="<?= $annee ?>" name="idAnnee">
                                <input type="hidden" value="<?= $pourc ?>" name="pourc_<?= $i ?>">
                                <?php echo $data['nom'] ?>
                              </td>
                              <td><?php echo $pourc ?> %</td>
                              <?php if ($pdo->query($requeteDecision)->rowCount() <= 0) { ?>
                                <td><select name="decJury_<?= $i ?>" class="form-select">
                                    <option disabled>Sélectionnez une décision</option>
                                    <option value="En cours de traitement">En cours de traitement</option>
                                    <option value="Monte la classe">Monte la classe</option>
                                    <option value="Double la classe">Double la classe</option>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idC_<?= $i ?>">
                                    <option disabled>Sélectionnez une classe</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_classe INNER JOIN t_option
                                     ON t_option.idO=t_classe.idO order by design asc";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idC']; ?>" <?php if ($result['idC'] === $idC) echo "Selected" ?>>
                                        <?php echo $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idA_<?= $i ?>">
                                    <option disabled>Sélectionnez une année</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_an";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idA']; ?>" <?php if ($result['idA'] === $annee) echo "Selected" ?>>
                                        <?php echo $result['designA'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                              <?php } else { ?>
                                <td><select name="decJury_<?= $i ?>" class="form-select">
                                    <option disabled>Sélectionnez une décision</option>
                                    <option value="En cours de traitement" <?php if ($resDec['decJury'] === 'En cours de traitement') echo "Selected" ?>>En cours de traitement</option>
                                    <option value="Monte la classe" <?php if ($resDec['decJury'] === 'Monte la classe') echo "Selected" ?>>Monte la classe</option>
                                    <option value="Double la classe" <?php if ($resDec['decJury'] === 'Double la classe') echo "Selected" ?>>Double la classe</option>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idC_<?= $i ?>">
                                    <option disabled>Sélectionnez une classe</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_classe INNER JOIN t_option
                                     ON t_option.idO=t_classe.idO order by design asc";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idC']; ?>" <?php if ($result['idC'] === $resDec['idC']) echo "Selected" ?>>
                                        <?php echo $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                                <td><select class="form-select" name="idA_<?= $i ?>">
                                    <option disabled>Sélectionnez une année</option>
                                    <?php
                                    $requeteAg = "SELECT * FROM t_an";
                                    $resultatAg = $pdo->query($requeteAg);
                                    while ($result = $resultatAg->fetch()) { ?>
                                      <option value="<?php echo $result['idA']; ?>" <?php if ($result['idA'] === $resDec['idA']) echo "Selected" ?>>
                                        <?php echo $result['designA'] ?>
                                      </option>
                                    <?php } ?>
                                  </select>
                                </td>
                              <?php } ?>
                            </tr>
                          <?php $i++;
                          } ?>
                        </tbody>
                      </table>
                      <a href="menuJury.php" class="btnModClose">Retourner</a>
                      <button type="submit" name="addOpBtn" class="btnModSave">Enregistrer</button>
                    </form>
                  <?php } ?>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>