<?php
session_start();
require_once('../../include/connexiondb.php');
require_once('../../include/fonctionPrint.php');

// Fonction pour insérer ou mettre à jour les données d'un élève dans la table spécifiée
function insertDecision($pdo, $idI, $idC, $idA, $idC_, $idA_, $pourc, $decJury)
{
    // L'enregistrement n'existe pas, effectuer une insertion
    $insertQuery = "INSERT INTO t_decision (idI,idC,idA,idC_,idA_,pourc,decJury) VALUES (:idI, :idC, :idA, :idC_, :idA_, :pourc, :decJury)";

    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
    $stmt->bindParam(':idC_', $idC_, PDO::PARAM_INT);
    $stmt->bindParam(':idA_', $idA_, PDO::PARAM_INT);
    $stmt->bindParam(':pourc', $pourc, PDO::PARAM_STR);
    $stmt->bindParam(':decJury', $decJury, PDO::PARAM_STR);

    return $stmt->execute();
}

function insertRedevable($pdo, $idI, $idC, $idA, $montR)
{
    // L'enregistrement n'existe pas, effectuer une insertion
    $insertQuery = "INSERT INTO t_redevable (idI, idC, idA, montR) VALUES (:idI, :idC, :idA, :montR)";

    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
    $stmt->bindParam(':montR', $montR, PDO::PARAM_STR);

    return $stmt->execute();
}

function insertInscrit($pdo, $idI, $idC, $idA, $idUser, $catEcole)
{
    //Recuperation des informations de l'eleve
    $rqIn = "SELECT * FROM t_inscrit WHERE idI='$idI'";
    $stmIns = $pdo->query($rqIn)->fetch();
    $photo = $stmIns['photo'];
    $nom = $stmIns['nom'];
    $nation = $stmIns['nation'];
    $sexe = $stmIns['sexe'];
    $ln = $stmIns['ln'];
    $dn = $stmIns['dn'];
    $ep = $stmIns['ep'];
    $nomP = $stmIns['nomP'];
    $profP = $stmIns['profP'];
    $telP = $stmIns['telP'];
    $nomM = $stmIns['nomM'];
    $profM = $stmIns['profM'];
    $telM = $stmIns['telM'];
    $pD = $stmIns['pD'];
    $trans = $stmIns['trans'];
    $hop = $stmIns['hop'];
    $adresse = $stmIns['adresse'];
    $numMat = $stmIns['numMat'];
    $etatI = $stmIns['etatI'];
    // L'enregistrement n'existe pas, effectuer une insertion
    $insertQuery = "INSERT INTO t_inscrit 
     (idC,idA,idUser,photo,nom,nation,sexe,ln,dn,ep,nomP,profP,telP,nomM,profM,telM,pD,trans,hop,adresse,numMat,catEcole,etatI) 
     VALUES (:idC,:idA,:idUser,:photo,:nom,:nation,:sexe,:ln,:dn,:ep,:nomP,:profP,:telP,:nomM,:profM,:telM,:pD,:trans,:hop,:adresse,:numMat,:catEcole,:etatI)";
    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
    $stmt->bindParam(':idUser', $idUser, PDO::PARAM_INT);
    $stmt->bindParam(':photo', $photo, PDO::PARAM_STR);
    $stmt->bindParam(':nom', $nom, PDO::PARAM_STR);
    $stmt->bindParam(':nation', $nation, PDO::PARAM_STR);
    $stmt->bindParam(':sexe', $sexe, PDO::PARAM_STR);
    $stmt->bindParam(':ln', $ln, PDO::PARAM_STR);
    $stmt->bindParam(':dn', $dn, PDO::PARAM_STR);
    $stmt->bindParam(':ep', $ep, PDO::PARAM_STR);
    $stmt->bindParam(':nomP', $nomP, PDO::PARAM_STR);
    $stmt->bindParam(':profP', $profP, PDO::PARAM_STR);
    $stmt->bindParam(':telP', $telP, PDO::PARAM_STR);
    $stmt->bindParam(':nomM', $nomM, PDO::PARAM_STR);
    $stmt->bindParam(':profM', $profM, PDO::PARAM_STR);
    $stmt->bindParam(':telM', $telM, PDO::PARAM_STR);
    $stmt->bindParam(':pD', $pD, PDO::PARAM_STR);
    $stmt->bindParam(':trans', $trans, PDO::PARAM_STR);
    $stmt->bindParam(':hop', $hop, PDO::PARAM_STR);
    $stmt->bindParam(':adresse', $adresse, PDO::PARAM_STR);
    $stmt->bindParam(':numMat', $numMat, PDO::PARAM_STR);
    $stmt->bindParam(':catEcole', $catEcole, PDO::PARAM_STR);
    $stmt->bindParam(':etatI', $etatI, PDO::PARAM_STR);

    return $stmt->execute();
}

// Soumission du formulaire
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['idClasse']) && isset($_POST['idAnnee'])) {
        $idC = $_POST['idClasse'];
        $idA = $_POST['idAnnee'];
        $annee = $idA;

        //Autre
        $idI = $_POST['idI'];
        $decJury = $_POST["decJury"];
        $idC_ = $_POST["idC"];
        $idA_ = $_POST["idA"];
        $idUser = $_SESSION['id'];

        // Récuperation des données
        $reqcatEcole = "SELECT * FROM t_classe WHERE idC='$idC_'";
        $stmcatEcole = $pdo->query($reqcatEcole)->fetch();
        $catEcole = $stmcatEcole['sec'];

        //Recuperation pourcentage
        $idIns = $idI;
        $reqcat = "SELECT * FROM t_inscrit WHERE idI='$idIns'";
        $stmcat = $pdo->query($reqcat)->fetch();
        $cat = $stmcat['catEcole'];
        /*
        if ($cat == 'Maternelle') {
            //Mes totaux
            $totalCote1 = getTotCotePerMat($pdo, $idIns, $annee, 'P1');
            $totalCote2 = getTotCotePerMat($pdo, $idIns, $annee, 'P2');
            $totalCote3 = getTotCotePerMat($pdo, $idIns, $annee, 'P3');
            $totalMaxPer = getTotCoteMaxMat($pdo, $idIns, $annee);
            //Pourcentage
            $pourc = round((($totalCote1 + $totalCote2 + $totalCote3) / ($totalMaxPer * 3)) * 100, 2);
        } elseif ($cat == 'Primaire') {
            //Mes totaux
            $totalCote1 = getTotCotePerPri($pdo, $idIns, $annee, 'P1');
            $totalCote2 = getTotCotePerPri($pdo, $idIns, $annee, 'P2');
            $totalCote3 = getTotCotePerPri($pdo, $idIns, $annee, 'Ex1');
            $totalCote4 = getTotCotePerPri($pdo, $idIns, $annee, 'P3');
            $totalCote5 = getTotCotePerPri($pdo, $idIns, $annee, 'P4');
            $totalCote6 = getTotCotePerPri($pdo, $idIns, $annee, 'Ex2');
            $totalCote7 = getTotCotePerPri($pdo, $idIns, $annee, 'P5');
            $totalCote8 = getTotCotePerPri($pdo, $idIns, $annee, 'P6');
            $totalCote9 = getTotCotePerPri($pdo, $idIns, $annee, 'Ex3');
            $totalMaxPer = getTotCoteMaxPri($pdo, $idIns, $annee);
            $totalMaxEx = getTotExMaxPri($pdo, $idIns, $annee);
            //Pourcentage
            $pourc = round((($totalCote1 + $totalCote2 + $totalCote3 + $totalCote4 + $totalCote5 + $totalCote6 + $totalCote7 + $totalCote8 + $totalCote9) / (($totalMaxPer * 2 + $totalMaxEx) * 3)) * 100, 2);
        } elseif ($cat == 'Secondaire') {
            //Mes totaux
            $totalCote1 = getTotCotePerSec($pdo, $idIns, $annee, 'P1');
            $totalCote2 = getTotCotePerSec($pdo, $idIns, $annee, 'P2');
            $totalCote3 = getTotCotePerSec($pdo, $idIns, $annee, 'Ex1');
            $totalCote4 = getTotCotePerSec($pdo, $idIns, $annee, 'P3');
            $totalCote5 = getTotCotePerSec($pdo, $idIns, $annee, 'P4');
            $totalCote6 = getTotCotePerSec($pdo, $idIns, $annee, 'Ex2');
            $totalMaxPer = getTotCoteMaxSec($pdo, $idIns, $annee);
            $totalMaxEx = getTotExMaxSec($pdo, $idIns, $annee);
            //Pourcentage
            $pourc = round((($totalCote1 + $totalCote2 + $totalCote3 + $totalCote4 + $totalCote5 + $totalCote6) / (($totalMaxPer * 2 + $totalMaxEx) * 2)) * 100, 2);
        }
        
        */
        $pourc=30;
        //Redevable
        $sqlRed = $pdo->query("SELECT  SUM(DISTINCT t_frais.montF) AS dejaPayer, 
            SUM(DISTINCT t_typeFrais.montTF) AS aPayer FROM  t_inscrit
            INNER JOIN t_classe ON t_inscrit.idC = t_classe.idC 
            INNER JOIN t_an ON t_inscrit.idA = t_an.idA 
            INNER JOIN t_option ON t_classe.idO = t_option.idO 
            INNER JOIN t_frais ON t_frais.idI = t_inscrit.idI 
            INNER JOIN t_typeFrais ON t_typeFrais.idTF = t_frais.idTF 
            INNER JOIN users ON t_frais.idUser = users.idUser  
            WHERE  t_inscrit.idI = '$idI' AND t_an.idA = '$idA'");
        $stmRed = $sqlRed->fetch();
        $redChamp = $stmRed['aPayer'] - $stmRed['dejaPayer'];

        // Récupérer le nombre d'élèves par classe et année
        $reqDecision = $pdo->query("SELECT * FROM t_decision WHERE idI='$idI'")->rowCount();

        if ($reqDecision == 1) {
            $msg_erreur = "Décisions deja effectuée pour cet élève s'il vous plaît !!!";
            header("Location:../decision.php?erreur=$msg_erreur");
            exit;
        } else {

            if ($decJury == "En cours de traitement") {
                // Appeler la fonction pour insérer ou mettre à jour
                insertDecision($pdo, $idI, $idC, $idA, $idC_, $idA_, $pourc, $decJury);
                //Vérification de la redevabilité
            } else {
                // Appeler la fonction pour insérer ou mettre à jour
                insertDecision($pdo, $idI, $idC, $idA, $idC_, $idA_, $pourc, $decJury);
                insertInscrit($pdo, $idI, $idC_, $idA_, $idUser, $catEcole);

                if ($redChamp > 0) {
                    // Appeler la fonction pour insérer ou mettre à jour
                    insertRedevable($pdo, $idI, $idC, $idA, $redChamp);
                }
            }
        }

        // Rediriger ou afficher un message de confirmation après l'enregistrement/mise à jour
        $msg_erreur = "Décisions du Jury initialisée avec succès";
        header("Location:../decision.php?succes=$msg_erreur");
    } else {
        $msg_erreur = "Il y a une erreur lors de l'initialisation des décisions du Jury.";
        header("Location:../decision.php?erreur=$msg_erreur");
    }
}
