<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['approvMedBtn']) &&
        isset($_POST['idM']) &&
        isset($_POST['idFour']) && 
        isset($_POST['qteA']) &&
        isset($_POST['pv']) &&
        isset($_POST['paEn'])
    ) {
        //Les variables
        $idM = $_POST['idM'];
        $idFour = $_POST['idFour'];
        $qteA = $_POST['qteA'];
        $paA = $_POST['paEn'];
        $pv = $_POST['pv'];

        if(is_numeric($paA) AND is_numeric($pv)){

             // Vérification du nom d'utilisateur s'il existe déjà
             $sqlM = "SELECT * FROM medicament WHERE idM = ?";
             $reqM = $pdo->prepare($sqlM);
             $reqM->execute([$idM]);
             $resM = $reqM->fetch();
             $stockMed = $resM['stock'];
             $stockApprov = $qteA + $stockMed;
             $desMed = $resM['design'];

            //Insert Approv
            $intg = (($pv - $paA) * 100) / $paA; 

            $sql = "INSERT INTO approv 
            (`idFour`,`idM`,`qteA`,`soldeIA`,`soldeA`) 
            VALUES (?,?,?,?,?)";
            $req = $pdo->prepare($sql);
            $req->execute([$idFour,$idM,$qteA,$stockMed,$stockApprov]);

            //Autre
            $sqlInv = "SELECT * FROM invest WHERE idM = ?";
            $reqInv = $pdo->prepare($sqlInv);
            $reqInv->execute([$idM]);
            $resultatInv = $reqInv->fetch();
            $stockInv = $resultatInv['stock'];
            $stockTotInvest = $qteA + $stockInv;
            $dateOperation = date("Y-m-d");

            $pvg = $paA + (($intg*$paA)/100);
            
            # Update des données dans la table 
            $sql = "UPDATE medicament SET `stock`=?,
            `paEn`=?,`intg`=?,`pvg`=? WHERE `idM`=? ";
            $req = $pdo->prepare($sql);
            $req->execute([$stockApprov,$paA,$intg,$pvg,$idM]);

            $sqlInvest = "UPDATE invest SET `stock`=?,`dateOp`=?,`paEn`=? WHERE `idM`=?";
            $reqInvest = $pdo->prepare($sqlInvest);
            $reqInvest->execute([$stockTotInvest,$dateOperation,$paA,$idM]);

            $msg_erreur = "Le produit ".$desMed." est approvisionné avec succès";
            header("Location:../approv.php?succes=$msg_erreur");
        }else{
            $msg_erreur = "Leprix doit être en numérique";
            header("Location:../approv.php?erreur=$msg_erreur");
        }
    }else{
        $msg_erreur = "Il y a une erreure";
        header("Location:../approv.php?erreur=$msg_erreur");
        exit;
    }
?>