<?php
    session_start();
    require_once('../../include/connexiondb.php');

    if(
        isset($_POST['addDepBtn']) &&
        isset($_POST['motif']) &&
        isset($_POST['tarif'])
    ){
        //Les variables
        $motif = $_POST['motif'];
        $tarif = $_POST['tarif'];
        // Mon algo
        $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
        $reqRec = $pdo->prepare($sqlRec);
        $reqRec->execute([1]);
        $resRech = $reqRec->fetch();
        $recette = $resRech['net'];

        if ($recette<$tarif) {
            $msg_erreur = "Le montant en caisse est insuffisant pour couvrir cette dépense";
            header("Location:../dep.php?erreur=$msg_erreur");
            exit;
        } else {
            # Update des données dans la table 
            $sql = "INSERT INTO magdepense (`motif`,`tarif`) VALUES(?,?)";
            $req = $pdo->prepare($sql);
            $req->execute([$motif,$tarif]);

            //Modif Caisse
            $sqlCaisse = "SELECT * FROM caisse WHERE idCaisse = ?";
            $reqCaisse = $pdo->prepare($sqlCaisse);
            $reqCaisse->execute([1]);
            $resCaisse = $reqCaisse->fetch();
            $ventes = $resCaisse['ventes'];
            $depenses = $resCaisse['depenses'];
            $creances = $resCaisse['creances'];

            $depenses_actuelle = $depenses + $tarif;
            $Net = $ventes - $depenses_actuelle - $creances;

            $sql4 = "UPDATE caisse SET `depenses`=? , `net`= ? WHERE `idCaisse`=?";
            $req4 = $pdo->prepare($sql4);
            $req4->execute([$depenses_actuelle,$Net,1]);

            #Message de succès
            $msg_erreur = "Dépense enregistrée avec succès";
            header("Location:../dep.php?succes=$msg_erreur");
        }
    }else{
        $msg_erreur = "Il y a une erreure";
        header("Location:../dep.php?erreur=$msg_erreur");
        exit;
    }
?>