<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['idM']) && 
        isset($_POST['idC']) &&
        isset($_POST['idDC'])
    ) {
        //Les variables
        $idDC = $_POST['idDC'];
        $idM = $_POST['idM'];
        $idC = $_POST['idC'];

        $sqlMedoc = "SELECT * FROM medicament WHERE idM = ?";
        $reqMedoc = $pdo->prepare($sqlMedoc);
        $reqMedoc->execute([$idM]);
        $resMedoc = $reqMedoc->fetch();
        $stock = $resMedoc['stock'];
        $designM = $resMedoc['design'];

        $sql = "SELECT * FROM detail_commande 
            INNER JOIN commande ON commande.idC=detail_commande.idC 
            INNER JOIN medicament ON medicament.idM=detail_commande.idM 
            WHERE detail_commande.idC=? AND medicament.idM=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC,$idM]);
        $res = $req->fetch();
        $qteDetail = $res['qte'];
        $pvEnStock = $res['prixV'];
          //Req commande
        $sqlcOM = "SELECT * FROM commande WHERE idC = ?";
        $reqCom = $pdo->prepare($sqlcOM);
        $reqCom->execute([$idC]);
        $resCom = $reqCom->fetch();
        $sta = $resCom['statut'];

        if($sta=="Credit"){
            # Insertion des données dans la table 
            $sql = "DELETE FROM detail_commande WHERE `idDC`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$idDC]);

            $montantCa = $qteDetail*$pvEnStock;

            //Update Credit Table
            $sqlCred = "SELECT * FROM credit WHERE idC = ?";
            $reqCred = $pdo->prepare($sqlCred);
            $reqCred->execute([$idC]);
            $resCred = $reqCred->fetch();
            $mCred = $resCred['mCred'];
            $montantCreditTot = $mCred - $montantCa;
            $sql = "UPDATE credit SET `mCred`=?
            WHERE `idC`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$montantCreditTot,$idC]);
            
            # Insertion des données dans la table Medoc
            $stockModif = $stock + $qteDetail;
            $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$stockModif,$idM]);

            # update des données dans la table  caisse
            $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
            $reqRec = $pdo->prepare($sqlRec);
            $reqRec->execute([1]);
            $resRech = $reqRec->fetch();
            $ventes = $resRech['ventes'];
            $depenses = $resRech['depenses'];
            $creances = $resRech['creances'];

            $credit_actuelle = $creances - $montantCa;
            $Net = $ventes - $depenses - $credit_actuelle;

            $sql = "UPDATE caisse SET `creances`=? , `net`= ? WHERE `idCaisse`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$credit_actuelle,$Net,1]);

            header("Location:../detail_vente.php?idC=$idC");
        }elseif($sta=="Cash"){
            # Insertion des données dans la table 
            $sql = "DELETE FROM detail_commande WHERE `idDC`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$idDC]);

            $stockModif = $stock + $qteDetail;
            # Insertion des données dans la table 
            $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$stockModif,$idM]);

            # update des données dans la table  caisse et ca
            $montantCa = $qteDetail*$pvEnStock;
        
            $sql = "DELETE FROM ca WHERE `idDC`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$idDC]);

            $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
            $reqRec = $pdo->prepare($sqlRec);
            $reqRec->execute([1]);
            $resRech = $reqRec->fetch();
            $ventes = $resRech['ventes'];
            $depenses = $resRech['depenses'];
            $creances = $resRech['creances'];

            $vente_actuelle = $ventes - $montantCa;
            $Net = $vente_actuelle - $depenses - $creances;

            $sql = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$vente_actuelle,$Net,1]);

            header("Location:../detail_vente.php?idC=$idC");
        }elseif($sta=="Proformat"){
            $sql = "DELETE FROM detail_commande WHERE `idDC`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$idDC]);

            header("Location:../detail_vente.php?idC=$idC");
        }
    }else{
        $msg_erreur = "Il y a une erreure";
        header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
        exit;
    }
?>