<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['updateMedBtn']) &&
        isset($_POST['idM']) &&
        isset($_POST['design']) && 
        isset($_POST['idCat']) &&
        isset($_POST['stock']) &&
        isset($_POST['paEn']) &&
        isset($_POST['pv']) && 
        isset($_POST['stockMin']) 
    ) {
        //Les variables
        $idM = $_POST['idM'];
        $paEn = $_POST['paEn'];
        $stock = $_POST['stock'];
        $design = $_POST['design'];
        $idCat = $_POST['idCat'];
        $pv = $_POST['pv'];
        $stockMin = $_POST['stockMin'];
    
        // Validation du formulaire
        if(is_numeric($paEn) AND is_numeric($pv)){
            $intg = (($pv - $paEn) * 100) / $paEn; 
            $pvg = $paEn + (($intg*$paEn)/100);
            # Insertion des données dans la table 
            $sql = "UPDATE medicament SET `idCat`=?,`design`=?,`stock`=?,
            `stockMin`=?,`paEn`=?,`intg`=?,`pvg`=? WHERE `idM`=? ";
            $req = $pdo->prepare($sql);
            $req->execute([$idCat,$design,$stock,$stockMin,$paEn,$intg,$pvg,$idM]);

            $sqlCat = "SELECT * FROM categorie WHERE idCat = ?";
            $reqCat = $pdo->prepare($sqlCat);
            $reqCat->execute([$idCat]);
            $resultatCat = $reqCat->fetch();
            $Cat = $resultatCat['designCat'];

            $dateOperation = date("Y-m-d");

            $sqlInvest = "UPDATE invest SET `designCat`=?, 
            `design`=?, `stock`=?, `paEn`=?, `dateOp`=? WHERE `idM`=?";
            $reqInvest = $pdo->prepare($sqlInvest);
            $reqInvest->execute([$Cat,$design,$stock,$paEn,$dateOperation,$idM]);

            #Message de succès
            $msg_erreur = "Produit modifié avec succès";
            header("Location:../med.php?succes=$msg_erreur");
        }else{
            $msg_erreur = "Le prix doit être un nombre numérique !";
            header("Location:../med.php?erreur=$msg_erreur");
            exit;
        }
    }
?>