<?php 
session_start();
if(!isset($_SESSION["login"])){
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requeteRecord="SELECT count(*) AS total_records FROM t_inscrit
INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
INNER JOIN t_option ON t_classe.idO=t_option.idO INNER JOIN t_an 
ON t_inscrit.idA=t_an.idA WHERE t_inscrit.idUser = '$idUser'
AND t_inscrit.idA='$ResultmaxAS' AND t_inscrit.nom LIKE '%$des%'";
$total_records=$pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1; 

$requete="SELECT * FROM t_inscrit INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
INNER JOIN t_option ON t_classe.idO=t_option.idO INNER JOIN t_an 
ON t_inscrit.idA=t_an.idA WHERE t_inscrit.idUser = '$idUser'
AND t_inscrit.idA='$ResultmaxAS' AND t_inscrit.nom LIKE '%$des%'
ORDER BY t_inscrit.nom ASC LIMIT $offset, $total_records_per_page";
$resultat=$pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent.php"); ?>

  <!-- Menu principal -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link" data-bs-target="#eleve-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-person-lines-fill"></i><span>Gestion des élèves</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="eleve-nav" class="nav-content collapse show" data-bs-parent="#sidebar-nav">
          <li>
            <a href="inseleve.php" class="active">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="preseleve.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
        </ul>
      </li><!-- End Eleve Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="pres.php">
          <i class="bi bi-person-check-fill"></i>
          <span>GRH-Présences</span>
        </a>
      </li><!-- End GRH Présence Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="vis.php">
          <i class="bi bi-person-video2"></i>
          <span>Gestion des visiteurs</span>
        </a>
      </li><!-- End GRH Présence Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Inscription</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Inscription</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
        <div class="alert alert-warning" role="alert">
          <?php echo htmlspecialchars($_GET['erreur']); ?>
        </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
        <div class="alert alert-success" role="alert">
          <?php echo htmlspecialchars($_GET['succes']); ?>
        </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Gestion des inscriptions <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddInsM" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a>
                  | <a data-bs-toggle="modal" data-bs-target="#modalPrint"  class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER </a> </span></h5>

                  <form method="get" action="inseleve.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit" ></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Elève</th>
                        <th scope="col">Classe</th>
                        <th scope="col">Année Scol</th>
                        <th scope="col">Date Ins</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1; while($data=$resultat->fetch()){ ?>
                        <tr>
                          <th scope="row"> <a class="btn" data-bs-toggle="modal" data-bs-target="#ModalViewPhotoInscrit<?php echo $data['idI']?>"><img src="../uploads/<?php echo $data['photo']?>" width="40" height="40" class="img-fluid rounded-4" alt=""></a></th>
                          <td><?php echo $data['nom']?></td>
                          <td><?php echo $data['design']." ".$data['designO']." ".$data['ord']?></td>
                          <td><?php echo $data['designA']?></td>
                          <td><?php echo date('d-m-Y',strtotime($data['dateI']))?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateIns<?php echo $data['idI']?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> </a>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintCarteIns<?php echo $data['idI']?>" class="btn btn-info"><span class="bi bi-printer-fill"></span> </a>
                          </td>
                        </tr>
                      <?php  $number++;  include('modal_include/ModalmodifierIns.php'); } ?> 
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                        echo "class=' page-item disabled'";
                      } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                        echo "href='inseleve.php?page_no=$previous_page&des=$des'";
                                      } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='inseleve.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='inseleve.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                        echo "class='disabled page-item'";
                      } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                          echo "href='inseleve.php?page_no=$next_page'"; } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='inseleve.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    } 
                     ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

    <!-- MODAL ADD Inscrit -->
  <div class="modal fade" id="modalAddInsM" tabindex="-1">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter une inscription</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form method="post" action="php_include/addIns.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

              <div class="row mb-3">
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Nom</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                    <input type="text" name="nom" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir le nom SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Nationalité</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-universal-access-circle"></i></span>
                    <input type="text" name="nation" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir la nationalité SVP !</div>
                  </div>
                </div> 
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Sexe</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                    <select name="sexe" id="titre" class="form-control" required>
                      <option value="Masculin">Masculin</option>
                      <option value="Feminin">Feminin</option>
                    </select>
                    <div class="invalid-feedback">Veillez choisir le sexe SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Lieu de naissance</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                    <input type="text" name="ln" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir le lieu SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Date de naissance</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-calendar3"></i></span>
                    <input type="date" name="dn" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir la date SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Ecole de provenance</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-mortarboard-fill"></i></span>
                    <input type="text" name="ep" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir l'école SVP !</div>
                  </div>
                </div>
              </div>

              <div class="row mb-3">
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Nom du Père</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                    <input type="text" name="nomP" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir le nom SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Fonction du Père</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                    <input type="text" name="profP" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir la fonction SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Téléphone du Père</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-phone"></i></span>
                    <input type="text" name="telP" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir le numéro SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Nom de la Mère</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                    <input type="text" name="nomM" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir le nom SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Fonction de la Mère</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                    <input type="text" name="profM" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir la fonction SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Téléphone de la Mère</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-phone"></i></span>
                    <input type="text" name="telM" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir le numéro SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Personne à Contacter</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                    <input type="text" name="pD" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir le nom SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Moyen de transport</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-car-front-fill"></i></span>
                    <input type="text" name="trans" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir le moyen SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Hopital de Référence</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-hospital-fill"></i></span>
                    <input type="text" name="hop" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez saisir l'hopital SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Adresse domicile</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-house-fill"></i></span>
                    <input type="text" name="adresse" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir l'adresse SVP !</div>
                  </div>
                </div>
                <div class="col-md-12 col-lg-12">
                  <label for="titre" class="form-label">Photo</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person-badge-fill"></i></span>
                    <input type="file" name="photo" class="form-control" id="titre">
                    <div class="invalid-feedback">Veillez choisir une image SVP !</div>
                  </div>
                </div>

                <div class="col-md-6 col-lg-6">
                  <br>
                  <label for="titre" class="form-label">Classe</label>
                  <select class="form-select search-classe" name="idC" required>
                    <?php 
                      $requeteAg="SELECT * FROM t_classe INNER JOIN t_option ON 
                      t_classe.idO=t_option.idO order by design asc";
                      $resultatAg=$pdo->query($requeteAg);
                      while($result=$resultatAg->fetch()){?>
                      <option value="<?php echo $result['idC'];?>">
                        <?php echo $result['design']." ".$result['designO']." ".$result['ord']?>
                      </option>
                    <?php } ?>
                  </select>
                </div>

                <div class="col-md-6 col-lg-6">
                  <br>
                  <label for="titre" class="form-label">Cycle</label>
                  <select class="form-select" name="catEcole" required>
                    <option value="Maternelle">Maternelle</option>
                    <option value="Primaire">Primaire</option>
                    <option value="Secondaire">Maternelle</option>
                  </select>
                </div>
              </div>

              <div class="modal-footer">
                <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
                <button type="submit" name="addInsMatBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
              </div>
            </form><!-- End Form -->
        </div>
        
      </div>
    </div>
  </div><!-- End Modal ADD Inscrit-->

    <!-- MODAL Print SERVICE -->
  <div class="modal fade" id="modalPrint" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Imprimession par date d'enregistrement</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form method="post" action="../include/listeInscritRec.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

              <div class="row mb-3">

                <div class="col-md-12 col-lg-12">
                  <label for="titre" class="form-label">Classe</label>
                  <select class="form-select id1" name="idC" required>
                    <?php 
                      $requeteAg="select * from t_classe order by design asc";
                      $resultatAg=$pdo->query($requeteAg);
                      while($result=$resultatAg->fetch()){?>
                      <option value="<?php echo $result['idC'];?>">
                        <?php echo $result['design']." ".$result['sec']." ".$result['ord']?>
                      </option>
                    <?php } ?>
                  </select>
                </div>
                <div class="col-md-12 col-lg-12">
                  <br>
                  <label for="titre" class="form-label">Première Date</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                    <input type="date" name="date1" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                  </div>
                </div>

                <div class="col-md-12 col-lg-12">
                  <br>
                  <label for="titre" class="form-label">Seconde Date</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                    <input type="date" name="date2" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                  </div>
                </div>
              </div>

              <div class="modal-footer">
                <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
                <button type="submit" name="addMedBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
              </div>
            </form><!-- End Change Password Form -->
        </div>
        
      </div>
    </div>
  </div><!-- End Modal pRINT SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>