<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');

$requete = "SELECT * FROM categorie ORDER BY designCat ASC ";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_stockagent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link" data-bs-target="#gest-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Gestions</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="gest-nav" class="nav-content collapse show" data-bs-parent="#sidebar-nav">
          <li>
            <a href="clients.php">
              <i class="bi bi-circle"></i><span>Clients</span>
            </a>
          </li>
          <li>
            <a href="fourn.php">
              <i class="bi bi-circle"></i><span>Fournisseurs</span>
            </a>
          </li>
          <li>
            <a href="categ.php" class="active">
              <i class="bi bi-circle"></i><span>Emplacement</span>
            </a>
          </li>
        </ul>
      </li><!-- End Gestions Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="med.php">
          <i>&#9764;</i>
          <span>Stock Produit</span>
        </a>
      </li><!-- End stock Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="investis.php">
          <i class="bi bi-snow2"></i>
          <span>Stock Investi</span>
        </a>
      </li><!-- End Stock Investi Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="approv.php">
          <i class="bi bi-cart4"></i>
          <span>Approvisionnement</span>
        </a>
      </li><!-- End Approv Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="ventes.php">
          <i class="bi bi-cart-fill"></i>
          <span>Ventes</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="serv_cre.php">
          <i class="bi bi-activity"></i>
          <span>Suivi des Créances</span>
        </a>
      </li><!-- End Créances Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="requis.php">
          <i class="bi bi-stack"></i>
          <span>Requisition</span>
        </a>
      </li><!-- End Requisition Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="invet.php">
          <i class="bi bi-stickies-fill"></i>
          <span>Inventaire</span>
        </a>
      </li><!-- End Inventaire Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="analyse.php">
          <i class="bi bi-slack"></i>
          <span>Analyse</span>
        </a>
      </li><!-- End Analyse Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Catégorie</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Emplacement</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Différentes Emplacements <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddCat" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a> </span></h5>

                  <table class="table datatable">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Designation</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"><?= $number ?></th>
                          <td><?php echo $data['designCat'] ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateCateg<?php echo $data['idCat'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> <strong> Modifier </strong> </a>
                          </td>
                        </tr>
                      <?php $number++;
                        include('modal_include/ModalmodifierCateg.php');
                      } ?>
                    </tbody>
                  </table>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

  <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalAddCat" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter un Emplacement</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addCateg.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Designation</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                  <input type="text" name="designCat" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir la désignation SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addCatBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>