<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['addMedBtn']) && 
        isset($_POST['design']) && 
        isset($_POST['idCat']) &&
        isset($_POST['stock']) &&
        isset($_POST['paEn']) &&
        isset($_POST['pv']) && 
        isset($_POST['stockMin']) 
    ) {

        //Les variables
        $paEn = $_POST['paEn'];
        $stock = $_POST['stock'];
        $design = $_POST['design'];
        $idCat = $_POST['idCat'];
        $pv = $_POST['pv'];
        $stockMin = $_POST['stockMin']; 

        $sqlVerif = "SELECT * FROM medicament WHERE design = ?";
        $reqVerif = $pdo->prepare($sqlVerif);
        $reqVerif->execute([$design]);

        if(is_numeric($paEn) AND is_numeric($pv)){
            if ($reqVerif->rowCount() > 0) {
                $msg_erreur = "Ce Produit est déjà dans le magasin, Veillez faire l'approvisionnement";
                header("Location:../med.php?erreur=$msg_erreur");
                exit;
            } else {
                $intg = (($pv - $paEn) * 100) / $paEn;
                $pvg = $paEn + (($intg*$paEn)/100);
                # Insertion des données dans la table 
                $sql = "INSERT INTO medicament 
                (`idCat`,`design`,`stock`,`stockMin`,`paEn`,`intg`,`pvg`) 
                VALUES (?,?,?,?,?,?,?)";
                $req = $pdo->prepare($sql);
                $req->execute([$idCat,$design,$stock,$stockMin,$paEn,$intg,$pvg]);

                $lastInsertId = $pdo->lastInsertId();

                $sqlCat = "SELECT * FROM categorie WHERE idCat = ?";
                $reqCat = $pdo->prepare($sqlCat);
                $reqCat->execute([$idCat]);
                $resultatCat = $reqCat->fetch();
                $Cat = $resultatCat['designCat'];

                $dateOperation = date("Y-m-d");

                $sqlInvest = "INSERT INTO invest 
                (`idM`, `designCat`, `design`, `stock`, `paEn`, `dateOp`) 
                VALUES (?,?,?,?,?,?)";
                $reqInvest = $pdo->prepare($sqlInvest);
                $reqInvest->execute([$lastInsertId,$Cat,$design,$stock,$paEn,$dateOperation]);

                #Message de succès
                $msg_erreur = "Produit ajouté avec succès dans le magasin";
                header("Location:../med.php?succes=$msg_erreur");
                exit;
            }
        }else{
            $msg_erreur = "Le prix doit être un nombre, veillez vérifier SVP";
            header("Location:../med.php?erreur=$msg_erreur");
            exit;
        }
    }else{
        $msg_erreur = "Il y a une erreure";
        header("Location:../med.php?erreur=$msg_erreur");
        exit;
    }
?>