<?php
session_start();
require_once('../../include/connexiondb.php');

if (isset($_POST['idC'])) {
    $idC = $_POST['idC'];

    $sqlRec = "SELECT * FROM commande WHERE idC = ?";
    $reqRec = $pdo->prepare($sqlRec);
    $reqRec->execute([$idC]);
    $resRech = $reqRec->fetch(); 
    $statut = $resRech['statut'];

    if ($statut == 'Cash') {
        $sql = "DELETE FROM commande WHERE `idC`=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC]);

        $sql2 = "UPDATE medicament INNER JOIN detail_commande ON medicament.idM=detail_commande.idM SET `stock`=(`stock`+`qte`) WHERE detail_commande.idC = ?";
        $req2 = $pdo->prepare($sql2);
        $req2->execute([$idC]);

        $sql3 = "SELECT SUM(prixV*qte) AS sumCA FROM detail_commande WHERE idC= ?";
        $req3 = $pdo->prepare($sql3);
        $req3->execute([$idC]);
        $res3 = $req3->fetch();
        $sumCA = $res3['sumCA'];

        $sql = "DELETE ca, detail_commande FROM ca INNER JOIN detail_commande ON detail_commande.idDC = ca.idDC WHERE detail_commande.idC = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC]);

        $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
        $reqRec = $pdo->prepare($sqlRec);
        $reqRec->execute([1]);
        $resRech = $reqRec->fetch();
        $ventes = $resRech['ventes'];
        $depenses = $resRech['depenses'];
        $creances = $resRech['creances'];

        $vente_actuelle = $ventes - $sumCA;
        $Net = $vente_actuelle - $depenses - $creances;

        $sql4 = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
        $req4 = $pdo->prepare($sql4);
        $req4->execute([$vente_actuelle, $Net, 1]);

        $msg_erreur = "Commande CASH annulée avec succès";
    } elseif ($statut == 'Credit') {
        $sql = "DELETE FROM commande WHERE `idC`=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC]);

        $sql1 = "SELECT SUM(prixV*qte) AS sumCA FROM detail_commande WHERE idC= ?";
        $req1 = $pdo->prepare($sql1);
        $req1->execute([$idC]);
        $res1 = $req1->fetch();
        $sumCA = $res1['sumCA'];

        $sql2 = "DELETE FROM credit WHERE `idC`=?";
        $req2 = $pdo->prepare($sql2);
        $req2->execute([$idC]);

        $sql6 = "DELETE FROM detail_commande WHERE detail_commande.idC= ?";
        $req6 = $pdo->prepare($sql6);
        $req6->execute([$idC]);

        $sql3 = "UPDATE medicament INNER JOIN detail_commande ON medicament.idM=detail_commande.idM SET `stock`=(`stock`+`qte`) WHERE detail_commande.idC = ?";
        $req3 = $pdo->prepare($sql3);
        $req3->execute([$idC]);

        $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
        $reqRec = $pdo->prepare($sqlRec);
        $reqRec->execute([1]);
        $resRech = $reqRec->fetch();
        $ventes = $resRech['ventes'];
        $depenses = $resRech['depenses'];
        $creances = $resRech['creances'];

        $creances_actuelle = $creances - $sumCA;
        $Net = $ventes - $depenses - $creances_actuelle;

        $sql4 = "UPDATE caisse SET `creances`=? , `net`= ? WHERE `idCaisse`=?";
        $req4 = $pdo->prepare($sql4);
        $req4->execute([$creances_actuelle, $Net, 1]);

        $msg_erreur = "Commande CREDIT annulée avec succès";
    } else {
        $sql = "DELETE FROM commande WHERE `idC`=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC]);
        $msg_erreur = "Commande PROFORMAT annulée avec succès";
    }

    header("Location:../ventes.php");
} else {
    $msg_erreur = "Il y a une erreur";
    header("Location:../ventes.php?erreur=$msg_erreur");
}
