<?php
session_start();
require_once('../../include/connexiondb.php');
if (
    isset($_POST['approvMedBtn']) &&
    isset($_POST['idA']) &&
    isset($_POST['idM']) &&
    isset($_POST['idFour']) &&
    isset($_POST['qteA']) &&
    isset($_POST['pv']) &&
    isset($_POST['paEn'])
) {
    //Les variables
    $idA = $_POST['idA'];
    $idM = $_POST['idM'];
    $idFour = $_POST['idFour'];
    $qteA = $_POST['qteA'];
    $paA = $_POST['paEn'];
    $pv = $_POST['pv'];

    if (is_numeric($paA) and is_numeric($pv)) {
        $intg = (($pv - $paA) * 100) / $paA;
        #Modif stock entrepot
        $sql = "SELECT * FROM approv WHERE idA = ?";
        $req = $pdo->prepare($sql);
        $req->execute([$idA]);
        $res = $req->fetch();
        $qteAMed = $res['qteA'];

        $sqlM = "SELECT * FROM medicament WHERE idM = ?";
        $reqM = $pdo->prepare($sqlM);
        $reqM->execute([$idM]);
        $resM = $reqM->fetch();
        $stockMed = $resM['stock'];
        $stockAp = $stockMed - $qteAMed;

        $sqlInv = "SELECT * FROM invest WHERE idM = ?";
        $reqInv = $pdo->prepare($sqlInv);
        $reqInv->execute([$idM]);
        $resultatInv = $reqInv->fetch();
        $stockInv = $resultatInv['stock'];
        $stockTotInvest = $stockInv - $qteAMed;

        # Update des données dans la table  Entrepot
        $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
        $req = $pdo->prepare($sql);
        $req->execute([$stockAp, $idM]);

        $sqlIv = "UPDATE invest SET `stock`=? WHERE `idM`=?";
        $reqIv = $pdo->prepare($sqlIv);
        $reqIv->execute([$stockTotInvest, $idM]);

        // Vérification du nom d'utilisateur s'il existe déjà
        $sqlM = "SELECT * FROM medicament WHERE idM = ?";
        $reqM = $pdo->prepare($sqlM);
        $reqM->execute([$idM]);
        $resM = $reqM->fetch();
        $stockMed = $resM['stock'];
        $stockApprov = $qteA + $stockMed;
        $desMed = $resM['design'];

        //Update Approv
        $sql = "UPDATE approv SET `idFour`=?,`qteA`=?,`soldeA`=?,`soldeIA`=?
            WHERE idA=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idFour, $qteA, $stockApprov, $stockMed, $idA]);

        //Autre
        $sqlInv = "SELECT * FROM invest WHERE idM = ?";
        $reqInv = $pdo->prepare($sqlInv);
        $reqInv->execute([$idM]);
        $resultatInv = $reqInv->fetch();
        $stockInv = $resultatInv['stock'];
        $stockTotInvest = $qteA + $stockInv;
        $dateOperation = date("Y-m-d");

        # Update des données dans la table 
        $pvg = $paA + (($intg * $paA) / 100);

        # Update des données dans la table 
        $sql = "UPDATE medicament SET `stock`=?,
            `paEn`=?,`intg`=?,`pvg`=? WHERE `idM`=? ";
        $req = $pdo->prepare($sql);
        $req->execute([$stockApprov, $paA, $intg, $pvg, $idM]);

        $sqlInvest = "UPDATE invest SET `stock`=?,`dateOp`=?,`paEn`=? WHERE `idM`=?";
        $reqInvest = $pdo->prepare($sqlInvest);
        $reqInvest->execute([$stockTotInvest, $dateOperation, $paA, $idM]);

        $msg_erreur = "L'approvisionnement du produit " . $desMed . " est modifié avec succès";
        header("Location:../approv.php?succes=$msg_erreur");
    } else {
        $msg_erreur = "Le prix unitaire d'achat doit être en numérique";
        header("Location:../approv.php?erreur=$msg_erreur");
    }
}
