<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord = "SELECT count(*) AS total_records 
FROM medicament INNER JOIN requis ON requis.idM=medicament.idM INNER JOIN 
categorie ON categorie.idCat=medicament.idCat
WHERE design like '%$des%' OR designCat like '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requete = "SELECT * FROM medicament INNER JOIN requis ON 
requis.idM=medicament.idM INNER JOIN 
categorie ON categorie.idCat=medicament.idCat
WHERE design like '%$des%' OR designCat like 
'%$des%' ORDER BY design ASC 
  LIMIT $offset, $total_records_per_page ";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_stockagent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#gest-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Gestions</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="gest-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="clients.php">
              <i class="bi bi-circle"></i><span>Clients</span>
            </a>
          </li>
          <li>
            <a href="fourn.php">
              <i class="bi bi-circle"></i><span>Fournisseurs</span>
            </a>
          </li>
          <li>
            <a href="categ.php">
              <i class="bi bi-circle"></i><span>Emplacement</span>
            </a>
          </li>
        </ul>
      </li><!-- End Gestions Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="med.php">
          <i>&#9764;</i>
          <span>Stock Produit</span>
        </a>
      </li><!-- End stock Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="investis.php">
          <i class="bi bi-snow2"></i>
          <span>Stock Investi</span>
        </a>
      </li><!-- End Stock Investi Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="approv.php">
          <i class="bi bi-cart4"></i>
          <span>Approvisionnement</span>
        </a>
      </li><!-- End Approv Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="ventes.php">
          <i class="bi bi-cart-fill"></i>
          <span>Ventes</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="serv_cre.php">
          <i class="bi bi-activity"></i>
          <span>Suivi des Créances</span>
        </a>
      </li><!-- End Créances Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link" href="requis.php">
          <i class="bi bi-stack"></i>
          <span>Requisition</span>
        </a>
      </li><!-- End Requisition Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="invet.php">
          <i class="bi bi-stickies-fill"></i>
          <span>Inventaire</span>
        </a>
      </li><!-- End Inventaire Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="analyse.php">
          <i class="bi bi-slack"></i>
          <span>Analyse</span>
        </a>
      </li><!-- End Analyse Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Requisitions</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Requisitions</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Liste des requisitions <span>| <a data-bs-toggle="modal" data-bs-target="#modaladdReq" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a>
                      | <a data-bs-toggle="modal" data-bs-target="#modalVider" class="btn btn-danger"><i class="bi bi-trash3"></i> VIDER</a>
                      | <a data-bs-toggle="modal" data-bs-target="#modalGenererRequis" class="btn btn-primary"><i class="bi bi-arrow-repeat"></i> GENERER</a>
                      | <a data-bs-toggle="modal" data-bs-target="#modalPrintBonCom" class="btn btn-warning"><i class="bi bi-printer-fill"></i> BON DE COMMANDE </a>
                    </span></h5>
                  <form method="get" action="requis.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Produit</th>
                        <th scope="col">Catégorie</th>
                        <th scope="col">Quantité</th>
                        <th scope="col">PA</th>
                        <th scope="col">Date</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $nombre = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <td scope="row"><?php echo $nombre ?></td>
                          <td><?php echo $data['design'] ?></td>
                          <td><?php echo $data['designCat'] ?></td>
                          <td><?php echo $data['qteReq'] . ' Produits' ?></td>
                          <td><?php echo $data['paReq'] . ' FC' ?></td>
                          <td><?php echo date('d-m-Y', strtotime($data['dateReq'])) ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateReq<?php echo $data['idReq'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> </a>
                          </td>
                        </tr>
                      <?php $nombre++;
                        include('modal_include/ModalmodifierMed.php');
                      } ?>
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                      echo "href='requis.php?page_no=$previous_page&des=$des'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='requis.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='requis.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                      echo "href='requis.php?page_no=$next_page'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='requis.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    } ?>
                  </ul>
                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MODAL Mod Suppri stock Ent -->
  <div class="modal fade" id="modalGenererRequis" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Générer automatiquement la Réquisition</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/genererRequis.php" class="tab-pane pt-3 needs-validation" novalidate>
            <h5 class="text-success">Voulez-vous générer la réquisition ?</h5>

            <label for="titre" class="form-label">Quantité Minimale</label>
            <div class="input-group has-validation">
              <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
              <input type="number" name="QuantMin" class="form-control" id="titre" required>
              <div class="invalid-feedback">Veillez saisir la quantité minimale valide SVP !</div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Annuler</button>
              <button type="submit" name="genererRequiBtn" class="btn btn-success">Valider</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal Suppri Med stock entrepot -->

  <!-- MODAL Mod Suppri stock Ent -->
  <div class="modal fade" id="modalVider" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Videz la Réquisition</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/viderRequis.php" class="tab-pane pt-3 needs-validation" novalidate>
            <h5 class="text-danger">Voulez-vous supprimer définitivement les informations
              de la table réquisition pour la réalisation d'un nouveau bon de commande ?</h5>
            <div class="modal-footer">
              <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Annuler</button>
              <button type="submit" name="viderRequiBtn" class="btn btn-success">Valider</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal Suppri Med stock entrepot -->
  <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalPrintBonCom" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Print le Bon de Commande</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="../include/bonComandeMed.php" target="_blank" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Première Date</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                  <input type="date" name="date1" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                </div>
              </div>

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Seconde Date</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                  <input type="date" name="date2" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="printBCBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- MODAL Mod Med -->
  <div class="modal fade" id="modaladdReq" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter une requisition</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addReq.php" class="tab-pane pt-3 needs-validation" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Produit</label>
                <select class="form-select" name="idM" id="example-search2">
                  <?php
                  $requeteMed = "select * from medicament inner join categorie 
                      on medicament.idCat=categorie.idCat";
                  $resultatMed = $pdo->query($requeteMed);
                  while ($result = $resultatMed->fetch()) { ?>
                    <option value="<?php echo $result['idM']; ?>">
                      <?php echo $result['design'] .
                        ' - PAU : ' . $result['paEn'] . ' FC - Stock : '
                        . $result['stock'] . ' produits - Cat : '
                        . $result['designCat']; ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Quantité</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                  <input type="number" name="qteReq" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir la quantité SVP !</div>
                </div>
              </div>
              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Prix d'achat Unitaire</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i>En FC</i></span>
                  <input type="text" name="paReq" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le prix SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addReqBtn" class="btnModSave">Requisitionner</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal Mod Med-->


  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>