<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");

if (!isset($_POST['idAut'])) {
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../DD/as.php?erreur=$msg_erreur");
    exit;
}

class myPDF extends FPDF {
    
    function Table($pdo){
        $idAut = $_POST['idAut'];
        $nomUser = $_SESSION["nom"];
        $requser = $pdo->query("SELECT * FROM t_autsortie
        INNER JOIN t_inscrit ON t_inscrit.idI=t_autsortie.idI
        INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
        INNER JOIN t_option ON t_classe.idO=t_option.idO INNER JOIN t_an 
        ON t_inscrit.idA=t_an.idA WHERE t_autsortie.idAut='$idAut'");

        while ($userinf = $requser->fetch()) {
            $this->AddPage();
            // En-tête de page
            $this->SetFont('courier', '', 10);
            $this->Cell(90, 0, 'REPUBLIQUE DEMOCRATIQUE DU CONGO', 0, 0, 'C');
            $this->Ln(4);
            $this->Cell(90, 0, "MINISTERE DE L'ENSEIGNEMENT PRIMAIRE", 0, 0, 'C');
            $this->Ln(4);
            $this->Cell(90, 0, "SECONDAIRE ET TECHNIQUE", 0, 0, 'C');
            $this->Ln(4);
            $this->SetFont('courier', 'B', 10);
            $this->Cell(90, 0, 'COMPLEXE SCOLAIRE LA RECONNAISSANCE', 0, 0, 'C');
            $this->Ln(4);
            $this->SetX(1);
            $this->Image('../uploads/logo.png', 1, 7, 15, 15);
            $this->Line(0, 25, 270-50, 25);
            $this->Ln(2);

            // Reste de l'en-tête
            $this->SetFont('Arial', 'B', 12);
            $this->Cell(0, 6, utf8_decode("AUTORISATION DE SORTIE N° " . sprintf('%06d', $userinf['idAut'])), 0, 1, 'C');
            $this->Ln(4);

            // Informations sur l'étudiant alignées à droite
            $this->SetFont('Helvetica', '', 10);
            $this->Cell(10, 5, 'Nom : ', 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, utf8_decode($userinf['nom']), 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(14, 5, 'Classe : ', 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, utf8_decode($userinf['design'].' '.$userinf['designO'].' '.$userinf['ord']), 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(28, 5, utf8_decode('Année Scolaire : '), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, $userinf['designA'], 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(10, 5, 'Motif : ', 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, utf8_decode($userinf['motif']), 0, 1, 'L');

            // Montant payé et Reste à payer
            $this->SetFont('Helvetica', '', 10);
            $this->Cell(28, 5, utf8_decode('Heure de sortie : '), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, $userinf['hS'], 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(29, 5, utf8_decode("Date d'execution : "), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, date('d-m-Y', strtotime($userinf['dateA'])), 0, 1, 'L');

            // Pied de page
            $this->Ln(3);
            $this->SetFont('Arial', 'B', 9);
            $this->Cell(0, 3, $nomUser, 0, 1, 'R');
            $this->SetFont('Arial', '', 9);
            $this->Cell(0, 7, utf8_decode('Directeur de discipline'), 0, 1, 'R');
            $this->SetFont('Arial', 'I', 9);
            $this->Cell(0, 3, utf8_decode('Fait à Kananga le ') . date('d-m-Y'), 0, 1, 'R');
        }
    }
}

$pdf = new myPDF('p', 'mm', array(100, 107));
$pdf->AliasNbPages();
$pdf->Table($pdo);
$pdf->Output();
?>
