DROP DATABASE IF EXISTS `school_plat_bdd`;
CREATE DATABASE `school_plat_bdd`;
USE `school_plat_bdd`;

CREATE TABLE `t_inscrit` (
  `idI` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idC` int(11) NOT NULL,
  `idA` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `photo` varchar(150) NOT NULL,
  `nom` varchar(100) NOT NULL,
  `nation` varchar(100) NOT NULL,
  `sexe` varchar(50) NOT NULL,
  `ln` varchar(100) NOT NULL,
  `dn` varchar(50) NOT NULL,
  `ep` varchar(100) NOT NULL,
  `nomP` varchar(100) NOT NULL,
  `profP` varchar(50) NOT NULL,
  `telP` varchar(50) NOT NULL,
  `nomM` varchar(100) NOT NULL,
  `profM` varchar(50) NOT NULL,
  `telM` varchar(50) NOT NULL,
  `pD` varchar(100) NOT NULL,
  `trans` varchar(100) NOT NULL,
  `hop` varchar(100) NOT NULL, 
  `adresse` varchar(100) NOT NULL,
  `numMat` varchar(50) NOT NULL,
  `catEcole` varchar(30) NOT NULL,
  `etatI` varchar(10) NOT NULL, -- Pour gerer les abadons
  `dateI` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
 
CREATE TABLE `t_classe` (
  `idC` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idO` int(11) NOT NULL,
  `design` varchar(100) NOT NULL,
  `sec` varchar(100) NOT NULL,
  `ord` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_an` (
  `idA` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `designA` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `t_an` (`idA`, `designA`) VALUES (1, '2024-2025');

CREATE TABLE `t_option` (
  `idO` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `designO` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_presence` (
  `idP` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `idI` int(11) NOT NULL,
  `hA` time NOT NULL,
  `hS` time NOT NULL,
  `eP` int(11) NOT NULL,
  `dateP` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_typeFrais` (
  `idTF` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idA` int(11) NOT NULL,
  `idC` int(11) NOT NULL,
  `catTF` varchar(100) NOT NULL, 
  `designTF` varchar(100) NOT NULL,
  `montTF` double(11,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_frais` (
  `idF` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idTF` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idA` int(11) NOT NULL,
  `idI` int(11) NOT NULL,
  `montF` double(11,2) NOT NULL,
  `etatF` int(11) NOT NULL,
  `dateF` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `lignedepense` (
  `idLd` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idA` int(11) NOT NULL,
  `designLd` varchar(120) NOT NULL,
  `tarifLd` double(11,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `depense` (
  `idDep` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `idLd` int(11) NOT NULL,
  `motif` varchar(120) NOT NULL,
  `tarif` double(11,2) NOT NULL,
  `dateDep` date NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `users` (
  `idUser` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `nomUser` varchar(100) NOT NULL,
  `loginUser` varchar(50) NOT NULL,
  `pw` varchar(200) NOT NULL,
  `fonction` varchar(50) NOT NULL,
  `imageUser` varchar(50) NOT NULL,
  `etatUser` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `users` (`idUser`, `nomUser`, `loginUser`, `pw`, `fonction`, `imageUser`, `etatUser`) VALUES
(1, 'WEB MASTER', 'admin', '$2y$10$Oz4kVJ.6hAUdmz1BaAIIv.iNKjVSz/gSMaLFUCAEQdPy.pfHmVW0C', 'Admin', 'user.png', 'Activer');

-- Gestion de cotes

CREATE TABLE `t_ens` (
  `idEns` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `nomEns` varchar(100) NOT NULL,
  `nivEns` varchar(50) NOT NULL,
  `loginEns` varchar(50) NOT NULL,
  `pwEns` varchar(200) NOT NULL,
  `imageEns` varchar(150) NOT NULL,
  `etatEns` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_jury` (
  `idJ` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idA` int(11) NOT NULL,
  `designJ` varchar(50) NOT NULL,
  `nomPres` varchar(50) NOT NULL,
  `nomSec` varchar(50) NOT NULL,
  `sectJ` varchar(50) NOT NULL,
  `loginJ` varchar(50) NOT NULL,
  `pwJ` varchar(200) NOT NULL,
  `etatJ` varchar(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Pour les décisions du jury et reinscription
CREATE TABLE `t_decision` (
  `idD` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idC` int(11) NOT NULL, 
  `idA` int(11) NOT NULL,
  `idC_` int(11) NOT NULL, 
  `idA_` int(11) NOT NULL,
  `pourc` double(11,2) NULL,
  `decJury` varchar(50) NULL -- monte la classe, double la classe
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Pour l'enregistrement des redevabilités
CREATE TABLE `t_redevable` (
  `idR` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idC` int(11) NOT NULL, -- Classe montante
  `idA` int(11) NOT NULL, -- Annee prochaine
  `montR` double(11,2) NOT NULL -- Total impayé si montant sum(montantTF-montantF) = 0 alors on ne fait pas enregistrement dans cette table
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4; 

-- Pour le payement des redevables
CREATE TABLE `t_payered` (
  `idPR` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idR` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `montPR` double(11,2) NOT NULL,
  `datePR` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_aff_jury` (
  `idAJ` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idJ` int(11) NOT NULL,
  `idC` int(11) NOT NULL,
  `dateAJ` date NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_categ` (
  `idCat` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `designCat` varchar(100) NOT NULL,
  `niveauCat` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_sous_categ` (
  `idSC` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idCat` int(11) NOT NULL,
  `designSousCat` varchar(100) NOT NULL,
  `niveauSousCat` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_cours` (
  `idCours` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idEns` int(11) NOT NULL,
  `idC` int(11) NOT NULL,
  `idA` int(11) NOT NULL,
  `idSC` int(11) NOT NULL,
  `designCours` varchar(100) NOT NULL,
  `maxPer` double NOT NULL,
  `maxEx` double NOT NULL,
  `typeCours` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_cote_mat` (
  `idCM` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idCours` int(11) NOT NULL,
  `coteP1` double NULL,
  `coteP2` double NULL,
  `coteP3` double NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_cote_pri` (
  `idCP` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idCours` int(11) NOT NULL,
  `coteP1` double NULL,
  `coteP2` double NULL,
  `coteEx1` double NULL,
  `coteP3` double NULL,
  `coteP4` double NULL,
  `coteEx2` double NULL,
  `coteP5` double NULL,
  `coteP6` double NULL,
  `coteEx3` double NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_cote_sec` (
  `idCP` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idCours` int(11) NOT NULL,
  `coteP1` double NULL,
  `coteP2` double NULL,
  `coteEx1` double NULL,
  `coteP3` double NULL,
  `coteP4` double NULL,
  `coteEx2` double NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_cond_mat` (
  `idCM` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idC` int(11) NOT NULL,
  `idA` int(11) NOT NULL,
  `P1` varchar(10) NOT NULL,
  `P2` varchar(10) NULL,
  `P3` varchar(10) NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_cond_pri` (
  `idCP` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idC` int(11) NOT NULL,
  `idA` int(11) NOT NULL,
  `P1` varchar(10) NULL,
  `P2` varchar(10) NULL,
  `P3` varchar(10) NULL,
  `P4` varchar(10) NULL,
  `P5` varchar(10) NULL,
  `P6` varchar(10) NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_cond_sec` (
  `idCP` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `idC` int(11) NOT NULL,
  `idA` int(11) NOT NULL,
  `P1` varchar(10) NULL,
  `P2` varchar(10) NULL,
  `P3` varchar(10) NULL,
  `P4` varchar(10) NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Gestion du personnel

CREATE TABLE `agent` (
  `idA` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `nomA` varchar(70) NOT NULL,
  `sexA` varchar(20) NOT NULL,
  `civA` varchar(50) NOT NULL,
  `telA` varchar(50) NOT NULL,
  `adA` varchar(50) NOT NULL,
  `foncA` varchar(50) NOT NULL,
  `nivA` varchar(50) NOT NULL,
  `salA` double(11,2) NOT NULL,
  `imgA` varchar(150) NOT NULL,
  `etatA` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `conge` ( 
  `idC` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idA` int(11) NOT NULL,
  `motif` varchar(50) NOT NULL,
  `deb` date NOT NULL,
  `fin` date NOT NULL,
  `mC` varchar(20) NOT NULL,
  `aC` varchar(20) NOT NULL,
  `ret` double(11,2) NOT NULL,
  `etatC` varchar(50) NOT NULL,
  `dateC` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `presence` (
  `idP` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idA` int(11) NOT NULL,
  `hA` time NOT NULL,
  `hS` time NOT NULL,
  `rha` double(11,2) NOT NULL,
  `rhs` double(11,2) NOT NULL,
  `mP` varchar(20) NOT NULL,
  `aP` varchar(20) NOT NULL,
  `eP` int(11) NOT NULL,
  `dateP` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `avance` ( 
  `idAv` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idA` int(11) NOT NULL,
  `motif` varchar(50) NOT NULL,
  `mtAv` double(11,2) NOT NULL,
  `mAv` varchar(20) NOT NULL,
  `aAv` varchar(20) NOT NULL,
  `dateAv` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `salaire` (
  `idS` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idA` int(11) NOT NULL,
  `jour` int(11) NOT NULL,
  `retN` double(11,2) NOT NULL,
  `avN` double(11,2) NOT NULL,
  `imp` double(11,2) NOT NULL,
  `logem` double(11,2) NOT NULL,
  `trans` double(11,2) NOT NULL,
  `prime` double(11,2) NOT NULL,
  `ipr` double(11,2) NOT NULL,
  `netS` double(11,2) NOT NULL,
  `mS` varchar(20) NOT NULL,
  `aS` varchar(20) NOT NULL,
  `dateS` date  NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `pargrh` (
  `idPar` int(11) NOT NULL PRIMARY KEY,
  `retC` double(11,2) NOT NULL,
  `retJ` double(11,2) NOT NULL,
  `retF` double(11,2) NOT NULL,
  `retO` double(11,2) NOT NULL,
  `impot` double(11,2) NOT NULL,
  `indem` double(11,2) NOT NULL,
  `hCom` time NOT NULL,
  `hFerm` time NOT NULL,
  `delO` time NOT NULL,
  `nbrJ` int(11) NOT NULL,
  `idAn` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `pargrh` (`idPar`, `retC`, `retJ`, `retF`, `retO`, `impot`, `indem`, `hCom`, `hFerm`, `delO`, `nbrJ`,`idAn`)
VALUES ('1', '0', '0', '0', '0', '0', '0', '00:00:00', '00:00:00', '00:00:00', '0','1');

CREATE TABLE `t_visite` (
  `idV` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `nomV` varchar(100) NOT NULL,
  `motifV` varchar(100) NOT NULL,
  `concV` varchar(100) NOT NULL,
  `haV` time NOT NULL,
  `dateV` date NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_autsortie` (
  `idAut` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `motif` varchar(200) NOT NULL,
  `hS` time NOT NULL,
  `statut` varchar(20) NOT NULL,
  `dateA` date NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `t_punition` (
  `idP` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `idI` int(11) NOT NULL,
  `motif` varchar(200) NOT NULL,
  `sanc` varchar(100) NOT NULL,
  `ddebut` date NOT NULL,
  `dfin` date NOT NULL,
  `statut` varchar(20) NOT NULL,
  `dateP` date NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
