<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");
date_default_timezone_set('Africa/Lubumbashi');
//Paramettre PRINT
$requeteParamPrint = "SELECT * FROM parprintmag WHERE idP";
$resultatPrint = $pdo->query($requeteParamPrint)->fetch();

//Requete print
$date1 = $_POST["date1"];
$date2 = $_POST["date2"];

$requeteUser = "SELECT * FROM medicament INNER JOIN categorie ON 
medicament.idCat=categorie.idCat INNER JOIN requis ON
requis.idM=medicament.idM WHERE requis.dateReq BETWEEN 
 '$date1' AND '$date2' ORDER BY medicament.design ASC";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();

$requeteQuant = "SELECT SUM(qteReq*paReq) AS totQuant FROM medicament INNER JOIN categorie ON 
medicament.idCat=categorie.idCat INNER JOIN requis ON requis.idM=medicament.idM 
WHERE requis.dateReq BETWEEN '$date1' AND '$date2'";
$rowCountQuant = $pdo->query($requeteQuant)->fetch();
$rowsQuant = $rowCountQuant['totQuant'];

if ($rowCountRequete === 0) {
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Stock/requis.php?erreur=$msg_erreur");
    exit;
} else {
    $res = $pdo->query($requeteUser)->fetch();

    $rowMedicament = $pdo->query($requeteUser)->rowCount();
    $numFac = sprintf('%04d', $rowMedicament);

    $image1 = "../uploads/" . $resultatPrint['log'];

    $pdf = new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('Arial', 'B', 15);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->cell(0, 20, $resultatPrint['soc'], 0, 0, 'C');
    $pdf->Ln(15);
    $pdf->setFont('courier', '', 15);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->setFont('courier', '', 15);
    $pdf->cell(0, 4, $resultatPrint['ad'], 0, 0, 'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->setFont('courier', '', 15);
    $pdf->cell(0, 4, $resultatPrint['pays'], 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->cell(0, 4, 'Contact : ' . $resultatPrint['con'], 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->cell(0, 4, 'Email : ' . $resultatPrint['em'], 0, 0, 'C');
    $pdf->Ln(5);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(0, 10, 'BON DE COMMANDE DES PRODUITS', 0, 0, 'C');
    $pdf->Ln(5);
    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial', '', 10);

    $pdf->Cell(59, 5, '', 0, 1); //end of line

    $pdf->Cell(130, 5, 'Nbr produits : ' . $numFac, 0, 0);
    $pdf->Cell(25, 5, 'DATE 1 : ', 0, 0);
    $pdf->Cell(34, 5, date('d-m-Y', strtotime($date1)) . " jusqu'au", 0, 1); //end of line

    $pdf->Cell(130, 5, utf8_decode('Bon de commande'), 0, 0);
    $pdf->Cell(25, 5, 'DATE 2 : ', 0, 0);
    $pdf->Cell(34, 5, date('d-m-Y', strtotime($date2)), 0, 1); //end of line

    $pdf->SetTextColor(0, 0, 0);
    $pdf->setFont('Arial', 'U', 15);
    $pdf->cell(55, 8, '', 0);
    $pdf->SetX(3);

    $pdf->cell(5, 8, '', 0);
    $pdf->Ln(5);
    $pdf->setFont('Arial', 'B', 12);
    $pdf->cell(10, 7, utf8_decode('N°'), 1, 0, 'C');
    $pdf->cell(75, 7, 'PRODUIT', 1, 0, 'C');
    $pdf->cell(30, 7, 'CATEGORIE', 1, 0, 'C');
    $pdf->cell(40, 7, 'QUANTITE', 1, 0, 'C');
    $pdf->cell(40, 7, 'PAU', 1, 0, 'C');
    $pdf->Ln(7);

    $pdf->setFont('courier', '', 9);

    $i = 1;
    $resultat = $pdo->query($requeteUser);
    if (isset($_POST['date1']) && isset($_POST['date2'])) {
        while ($ins = $resultat->fetch()) {
            $pdf->cell(10, 7, $i++, 1, 0, 'C');
            $pdf->cell(75, 7, utf8_decode(substr($ins['design'], 0, 36)), 1);
            $pdf->cell(30, 7, utf8_decode(substr($ins['designCat'], 0, 16)), 1);
            $pdf->cell(40, 7, utf8_decode(number_format($ins['qteReq'], 2, '.', ' ')), 1, 0, 'R');
            $pdf->cell(40, 7, utf8_decode(number_format($ins['paReq'], 2, '.', ' ')), 1, 0, 'R');
            $pdf->Ln(7);
        }
    }

    $pdf->setFont('Arial', 'B', 8);
    $pdf->cell(115, 7, '', 0);
    $pdf->cell(40, 7, "TOTAL BC", 1);
    $pdf->cell(40, 7, number_format($rowsQuant, 2, '.', ' ') . ' $', 1, 0, 'R');
    $pdf->Ln(7);

    $pdf->setFont('Arial', 'I', 9);
    //Décalage à droite
    $pdf->Cell(125);
    //Numéro de page
    $pdf->Cell(0, 10, utf8_decode('Fait à ' . $resultatPrint['vil']) . ' Le ' . date('d-m-Y H:i:s') . ' ', 0, 0, 'C');

    $formatname = "boncommande-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
