<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
date_default_timezone_set('Africa/Lubumbashi');

// Paramètres d'impression
$requeteParamPrint = "SELECT * FROM parprintmag WHERE idP";
$resultatPrint = $pdo->query($requeteParamPrint)->fetch();

// Requête pour récupérer l'ID de la commande
$idC = $_GET['idC'];

$newEtat = "1";
$sqlRed = "UPDATE commande SET etatC = ? WHERE idC=?";
$reqRed = $pdo->prepare($sqlRed);
$reqRed->execute([$newEtat, $idC]);

// Requête pour récupérer les détails de la commande
$requeteUser = "
    SELECT * 
    FROM detail_commande 
    INNER JOIN commande ON commande.idC = detail_commande.idC 
    INNER JOIN medicament ON medicament.idM = detail_commande.idM 
    INNER JOIN client ON client.idClient = commande.idClient 
    WHERE commande.idC = '$idC' AND commande.statut = 'Cash' 
    ORDER BY design ASC
";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if ($rowCountRequete === 0) {
    // Message d'erreur si la commande n'a pas de détails
    $msg_erreur = "Veuillez compléter les articles à cette facture.";
    header("Location:../Stock/ventes.php?erreur=$msg_erreur");
    exit;
} else {
    // Récupération des données de la commande
    $res = $pdo->query($requeteUser)->fetch();
    $nomC = $res['nom'];
    $tel = $res['telephone'];
    $add = $res['adresse'];
    $date = $res['dateC'];

    // Calcul de la somme des prix (en enlevant la somme des quantités)
    $requeteSomme = "
        SELECT SUM(prixV * qte) AS sommeFac 
        FROM detail_commande
        INNER JOIN commande ON commande.idC = detail_commande.idC 
        INNER JOIN medicament ON medicament.idM = detail_commande.idM 
        INNER JOIN client ON client.idClient = commande.idClient 
        WHERE commande.idC = '$idC'
    ";
    $resSomme = $pdo->query($requeteSomme)->fetch();
    $sommeFacture = $resSomme['sommeFac'];

    // Numéro de la facture
    $reqCountCom = "SELECT * FROM commande";
    $rowCountCom = $pdo->query($reqCountCom)->rowCount();
    $numFac = sprintf('%04d', $rowCountCom);

    // Chargement du logo
    $image1 = "../uploads/" . $resultatPrint['log'];

    // Création du PDF
    $pdf = new FPDF();
    $pdf->AddPage();

    // Affichage du logo
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);

    // Informations de la société
    $pdf->SetFont('Arial', 'B', 15);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->Cell(0, 20, utf8_decode($resultatPrint['soc']), 0, 0, 'C');
    $pdf->Ln(15);
    $pdf->SetFont('Courier', '', 12);
    $pdf->Cell(0, 4, utf8_decode($resultatPrint['ad']), 0, 0, 'C');
    $pdf->Ln(7);
    $pdf->Cell(0, 4, utf8_decode($resultatPrint['pays']), 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->Cell(0, 4, 'Contact : ' . $resultatPrint['con'], 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->Cell(0, 4, 'Email : ' . $resultatPrint['em'], 0, 0, 'C');
    $pdf->Ln(10);

    // Informations client
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(130, 5, 'FACTURE A', 0, 0);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(59, 5, '', 0, 1);
    $pdf->Cell(130, 5, utf8_decode(strtoupper($nomC)), 0, 0);
    $pdf->Cell(25, 5, 'DATE COM : ', 0, 0);
    $pdf->Cell(34, 5, date('d-m-Y', strtotime($date)), 0, 1);
    $pdf->Cell(130, 5, 'Cont. ' . $tel, 0, 0);
    $pdf->Cell(25, 5, 'FACTURE ' . utf8_decode('N°') . ' ', 0, 0);
    $pdf->Cell(34, 5, $numFac, 0, 1);
    $pdf->Cell(130, 5, 'AD. ' . utf8_decode($add), 0, 0);
    $pdf->Ln(10);

    // En-tête du tableau
    function headerTable($pdf) {
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(10, 7, utf8_decode('N°'), 1, 0, 'C');
        $pdf->Cell(80, 7, 'PRODUIT', 1, 0, 'C');
        $pdf->Cell(30, 7, 'PU', 1, 0, 'C');
        $pdf->Cell(25, 7, 'QTE', 1, 0, 'C');
        $pdf->Cell(45, 7, 'PRIX TOTAL', 1, 0, 'C');
        $pdf->Ln();
    }

    headerTable($pdf);

    // Lignes du tableau
    $pdf->SetFont('Arial', '', 10);
    $i = 1;
    foreach ($pdo->query($requeteUser) as $detail) {
        if ($pdf->GetY() > 260) { // Gestion de débordement
            $pdf->AddPage();
            headerTable($pdf);
        }
        $pdf->Cell(10, 7, $i++, 1, 0, 'C');
        $pdf->Cell(80, 7, utf8_decode(substr($detail['design'], 0, 40)), 1);
        $pdf->Cell(30, 7, number_format($detail['prixV'], 2, '.', ' '), 1, 0, 'R');
        $pdf->Cell(25, 7, $detail['qte'], 1, 0, 'R');
        $pdf->Cell(45, 7, number_format($detail['qte'] * $detail['prixV'], 2, '.', ' '), 1, 0, 'R');
        $pdf->Ln();
    }

    // Ajouter la ligne Total Facture dans le tableau
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(145, 7, 'TOTAL FACTURE', 1, 0, 'R'); // Fusion des colonnes précédentes
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(45, 7, number_format($sommeFacture, 2, '.', ' ') . ' FC', 1, 0, 'R'); // Colonne du total
    $pdf->Ln();

    // Pied de page
    $pdf->SetFont('Arial', 'I', 11);
    $pdf->Cell(0, 10, utf8_decode('Fait à ' . $resultatPrint['vil'] . ' le ' . date('d-m-Y H:i:s')), 0, 0, 'C');

    // Sauvegarde et affichage du PDF
    $formatname = "facture-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
?>
