<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");
date_default_timezone_set('Africa/Lubumbashi');

// Paramètres PRINT
$requeteParamPrint = "SELECT * FROM parprintmag WHERE idP";
$resultatPrint = $pdo->query($requeteParamPrint)->fetch();

// Requête print
$date1 = $_POST["date1"];
$date2 = $_POST["date2"];
$idM = $_POST["idM"];

// Récupérer les données des entrées de stock
$stmtEntrees = $pdo->prepare("SELECT a.idA AS numero, a.dateA AS date, a.qteA AS quantite, a.soldeA, a.soldeIA 
                            FROM approv a 
                            WHERE a.idM = :idM AND a.dateA BETWEEN :date1 AND :date2 
                            ORDER BY a.dateA, a.idA ASC");
$stmtEntrees->execute(['idM' => $idM, 'date1' => $date1, 'date2' => $date2]);
$entrees = $stmtEntrees->fetchAll(PDO::FETCH_ASSOC);

// Récupérer les données des sorties de stock
$stmtSorties = $pdo->prepare("SELECT dc.idDC AS numero, c.dateC AS date, dc.qte AS quantite, dc.soldeS, dc.soldeIS 
                            FROM detail_commande dc 
                            JOIN commande c ON dc.idC = c.idC 
                            WHERE dc.idM = :idM AND c.dateC BETWEEN :date1 AND :date2 
                            ORDER BY c.dateC, dc.idDC ASC");
$stmtSorties->execute(['idM' => $idM, 'date1' => $date1, 'date2' => $date2]);
$sorties = $stmtSorties->fetchAll(PDO::FETCH_ASSOC);

// Récupérer le nom du produit
$stmtNom = $pdo->prepare("SELECT * FROM medicament 
INNER JOIN categorie ON medicament.idCat=categorie.idCat
WHERE medicament.idM = :idM");
$stmtNom->execute(['idM' => $idM]);
$resnomProduit = $stmtNom->fetch();
$nomProduit = $resnomProduit['design'];
$nomCat = $resnomProduit['designCat'];
$stockProduit = $resnomProduit['stock'];

$image1 = "../uploads/" . $resultatPrint['log'];

// Fonction pour ajouter l'en-tête des tableaux
function addTableHeaders($pdf)
{
    $pdf->SetFont('Helvetica', 'B', 8); // Les titres sont en gras

    // Tableau des entrées
    $pdf->Cell(10.75, 5, utf8_decode("N°"), 1, 0, 'C');
    $pdf->Cell(20.75, 5, utf8_decode("Date"), 1, 0, 'C');
    $pdf->Cell(20.75, 5, utf8_decode("Quantité"), 1, 0, 'C');
    $pdf->Cell(21, 5, utf8_decode("Solde Initial"), 1, 0, 'C');
    $pdf->Cell(21.75, 5, utf8_decode("Solde Final"), 1, 0, 'C');

    // Tableau des sorties
    $pdf->Cell(10.75, 5, utf8_decode("N°"), 1, 0, 'C');
    $pdf->Cell(20.75, 5, utf8_decode("Date"), 1, 0, 'C');
    $pdf->Cell(20.75, 5, utf8_decode("Quantité"), 1, 0, 'C');
    $pdf->Cell(21, 5, utf8_decode("Solde Initial"), 1, 0, 'C');
    $pdf->Cell(21.75, 5, utf8_decode("Solde Final"), 1, 0, 'C');
    $pdf->Ln(5);
}

// Création du PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->Image($image1, 5, $pdf->GetY(), 30.72);
$pdf->SetFont('Arial', 'B', 15);
$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(0, 20, $resultatPrint['soc'], 0, 0, 'C');
$pdf->Ln(15);
$pdf->SetFont('courier', '', 15);
$pdf->Cell(0, 4, $resultatPrint['ad'], 0, 0, 'C');
$pdf->Ln(8);
$pdf->Cell(0, 4, $resultatPrint['pays'], 0, 0, 'C');
$pdf->Ln(12);

$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(50, 7, 'FICHE DE STOCK', 1, 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(59, 9, '', 0, 1); // End of line
$pdf->Cell(130, 5, utf8_decode('Article : ' . strtoupper($nomProduit)), 0, 0);
$pdf->Cell(130, 5, utf8_decode('Emplacement : ' . strtoupper($nomCat)), 0, 0);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Stock disponible : ' . $stockProduit . ' Produits'), 0, 0);
$pdf->Cell(130, 5, utf8_decode('Période : du ' . date('d/m/Y', strtotime($date1)) . ' au ' . date('d/m/Y', strtotime($date2))), 0, 0);
$pdf->Ln(8);

// Colonnes des entrées et sorties en gras
$pdf->SetFont('Helvetica', 'B', 12);
$pdf->Cell(95, 7, utf8_decode("ENTRÉES"), 1, 0, 'C');
$pdf->Cell(95, 7, utf8_decode("SORTIES"), 1, 0, 'C');
$pdf->Ln(7);

// Ajouter l'en-tête du tableau
addTableHeaders($pdf);

// Fusionner les données entrées et sorties par date
$maxRows = max(count($entrees), count($sorties));
for ($i = 0; $i < $maxRows; $i++) {
    // Vérifier si un saut de page est nécessaire
    if ($pdf->GetY() > 270) {
        $pdf->AddPage();
        addTableHeaders($pdf);
    }

    // Affichage des données en texte non gras
    $pdf->SetFont('Helvetica', '', 8);

    // Données des entrées
    if (isset($entrees[$i])) {
        $row = $entrees[$i];
        $pdf->Cell(10.75, 5, $i + 1, 1, 0, 'C');
        $pdf->Cell(20.75, 5, date('d/m/Y', strtotime($row['date'])), 1, 0, 'C');
        $pdf->Cell(20.75, 5, $row['quantite'], 1, 0, 'R');
        $pdf->Cell(21, 5, $row['soldeIA'], 1, 0, 'R');
        $pdf->Cell(21.75, 5, $row['soldeA'], 1, 0, 'R');
    } else {
        // Cellules vides si pas de données d'entrée
        $pdf->Cell(10.75, 5, '', 1, 0, 'C');
        $pdf->Cell(20.75, 5, '', 1, 0, 'C');
        $pdf->Cell(20.75, 5, '', 1, 0, 'R');
        $pdf->Cell(21, 5, '', 1, 0, 'R');
        $pdf->Cell(21.75, 5, '', 1, 0, 'R');
    }

    // Données des sorties
    if (isset($sorties[$i])) {
        $row = $sorties[$i];
        $pdf->Cell(10.75, 5, $i + 1, 1, 0, 'C');
        $pdf->Cell(20.75, 5, date('d/m/Y', strtotime($row['date'])), 1, 0, 'C');
        $pdf->Cell(20.75, 5, $row['quantite'], 1, 0, 'R');
        $pdf->Cell(21, 5, $row['soldeIS'], 1, 0, 'R');
        $pdf->Cell(21.75, 5, $row['soldeS'], 1, 0, 'R');
    } else {
        // Cellules vides si pas de données de sortie
        $pdf->Cell(10.75, 5, '', 1, 0, 'C');
        $pdf->Cell(20.75, 5, '', 1, 0, 'C');
        $pdf->Cell(20.75, 5, '', 1, 0, 'R'); $pdf->Cell(21, 5, '', 1, 0, 'R'); $pdf->Cell(21.75, 5, '', 1, 0, 'R'); }


    $pdf->Ln(5);
}

$pdf->Output();
