<?php

function calculateGrade($score) {
    if ($score < 40) {
        return 'MA';  // Mention Insuffisante
    } elseif ($score < 50) {
        return 'M';   // Mauvais
    } elseif ($score < 60) {
        return 'B';   // Bien
    } elseif ($score < 70) {
        return 'AB';  // Assez Bien
    } elseif ($score < 80) {
        return 'TB';  // Très Bien
    } else {
        return 'E';   // Excellent
    }
}

function getTotCotePerMat($bdd, $idI, $annee, $per)
{
    $totalCote = 0;
    $sql = "SELECT c.designCours, 
            SUM(IFNULL(cs.cote{$per}, 0)) AS totalCote
            FROM t_cote_mat cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalCote += $row['totalCote'];
    }

    return $totalCote;
}

function getTotCoteMaxMat($bdd, $idI, $annee)
{
    $totalMax = 0;
    $sql = "SELECT c.designCours, SUM(c.maxPer) AS totalMaxPer
            FROM t_cote_mat cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalMax += $row['totalMaxPer'];
    }

    return $totalMax;
}

function getTotCotePerPri($bdd, $idI, $annee, $per)
{
    $totalCote = 0;
    $sql = "SELECT c.designCours, 
            SUM(IFNULL(cs.cote{$per}, 0)) AS totalCote
            FROM t_cote_pri cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalCote += $row['totalCote'];
    }

    return $totalCote;
}

function getTotCoteMaxPri($bdd, $idI, $annee)
{
    $totalMax = 0;
    $sql = "SELECT c.designCours, SUM(c.maxPer) AS totalMaxPer
            FROM t_cote_pri cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalMax += $row['totalMaxPer'];
    }

    return $totalMax;
}

function getTotCotePerSec($bdd, $idI, $annee, $per)
{
    $totalCote = 0;
    $sql = "SELECT c.designCours, 
            SUM(IFNULL(cs.cote{$per}, 0)) AS totalCote
            FROM t_cote_sec cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalCote += $row['totalCote'];
    }

    return $totalCote;
}

function getTotCoteMaxSec($bdd, $idI, $annee)
{
    $totalMax = 0;
    $sql = "SELECT c.designCours, SUM(c.maxPer) AS totalMaxPer
            FROM t_cote_sec cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalMax += $row['totalMaxPer'];
    }

    return $totalMax;
}

//Max Examen
function getTotExMaxSec($bdd, $idI, $annee)
{
    $totalMax = 0;
    $sql = "SELECT c.designCours, SUM(c.maxEx) AS totalMax
            FROM t_cote_sec cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalMax += $row['totalMax'];
    }

    return $totalMax;
}

function getTotExMaxPri($bdd, $idI, $annee)
{
    $totalMax = 0;
    $sql = "SELECT c.designCours, SUM(c.maxEx) AS totalMax
            FROM t_cote_pri cs
            JOIN t_cours c ON cs.idCours = c.idCours
            JOIN t_an a ON c.idA = a.idA
            WHERE cs.idI = :idI AND a.idA = :annee
            GROUP BY c.designCours";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':annee', $annee, PDO::PARAM_INT);
    $stmt->execute();

    // Loop through the results
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $totalMax += $row['totalMax'];
    }

    return $totalMax;
}

//Determiner place période
function getPlaceEleveSecPer($bdd, $idI, $annee, $per, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.cote{$per}, 0)) AS totalCote
        FROM t_cote_sec cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom ORDER BY totalCote DESC, e.nom ASC";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = '';

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote'];

        if ($previousTotal !== null && $row['totalCote'] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $row['totalCote'];
        $previousName = $row['nom'];
    }

    return null;
}


function getPlaceEleveMatPer($bdd, $idI, $annee, $per, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.cote{$per}, 0)) AS totalCote
        FROM t_cote_mat cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom ORDER BY totalCote DESC, e.nom ASC";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = '';

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote'];

        if ($previousTotal !== null && $row['totalCote'] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $row['totalCote'];
        $previousName = $row['nom'];
    }

    return null;
}


function getPlaceElevePriPer($bdd, $idI, $annee, $per, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.cote{$per}, 0)) AS totalCote
        FROM t_cote_pri cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom ORDER BY totalCote DESC, e.nom ASC";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = '';

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote'];

        if ($previousTotal !== null && $row['totalCote'] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $row['totalCote'];
        $previousName = $row['nom'];
    }

    return null;
}


//Determine place trimestre Secondaire
function getPlaceEleveSecTrim1($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP1, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP2, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteEx1, 0)) AS totalExamen
        FROM t_cote_sec cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP1, 0)) + SUM(IFNULL(cs.coteP2, 0)) + SUM(IFNULL(cs.coteEx1, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalExamen'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}

function getPlaceEleveSecTrim2($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP3, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP4, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteEx2, 0)) AS totalExamen
        FROM t_cote_sec cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP3, 0)) + SUM(IFNULL(cs.coteP4, 0)) + SUM(IFNULL(cs.coteEx2, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalExamen'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}

//Determine place trimestre Primaire
function getPlaceElevePriTrim1($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP1, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP2, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteEx1, 0)) AS totalExamen
        FROM t_cote_pri cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP1, 0)) + SUM(IFNULL(cs.coteP2, 0)) + SUM(IFNULL(cs.coteEx1, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalExamen'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}

function getPlaceElevePriTrim2($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP3, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP4, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteEx2, 0)) AS totalExamen
        FROM t_cote_pri cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP3, 0)) + SUM(IFNULL(cs.coteP4, 0)) + SUM(IFNULL(cs.coteEx2, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalExamen'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}

function getPlaceElevePriTrim3($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP5, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP6, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteEx3, 0)) AS totalExamen
        FROM t_cote_pri cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP5, 0)) + SUM(IFNULL(cs.coteP6, 0)) + SUM(IFNULL(cs.coteEx3, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalExamen'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}

//Determine place Fin d'année
function getPlaceEleveMatFin($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP1, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP2, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteP3, 0)) AS totalCote3
        FROM t_cote_mat cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP1, 0)) + SUM(IFNULL(cs.coteP2, 0)) + SUM(IFNULL(cs.coteP3, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalCote3'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}

function getPlaceElevePriFin($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP1, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP2, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteP3, 0)) AS totalCote3,
        SUM(IFNULL(cs.coteP4, 0)) AS totalCote4,
        SUM(IFNULL(cs.coteP5, 0)) AS totalCote5,
        SUM(IFNULL(cs.coteP6, 0)) AS totalCote6,
        SUM(IFNULL(cs.coteEx1, 0)) AS totalCote7,
        SUM(IFNULL(cs.coteEx2, 0)) AS totalCote8,
        SUM(IFNULL(cs.coteEx3, 0)) AS totalCote9
        FROM t_cote_pri cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP1, 0)) + SUM(IFNULL(cs.coteP2, 0)) + SUM(IFNULL(cs.coteP3, 0)) + SUM(IFNULL(cs.coteP4, 0)) + SUM(IFNULL(cs.coteP5, 0)) + SUM(IFNULL(cs.coteP6, 0)) + SUM(IFNULL(cs.coteEx1, 0)) + SUM(IFNULL(cs.coteEx2, 0)) + SUM(IFNULL(cs.coteEx3, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalCote3'] + $row['totalCote4'] + $row['totalCote5'] + $row['totalCote6'] + $row['totalCote7'] + $row['totalCote8'] + $row['totalCote9'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}

function getPlaceEleveSecFin($bdd, $idI, $annee, $idC)
{
    $totalCote = array();

    $sql = "SELECT cs.idI, e.nom,
        SUM(IFNULL(cs.coteP1, 0)) AS totalCote1,
        SUM(IFNULL(cs.coteP2, 0)) AS totalCote2,
        SUM(IFNULL(cs.coteP3, 0)) AS totalCote3,
        SUM(IFNULL(cs.coteP4, 0)) AS totalCote4,
        SUM(IFNULL(cs.coteEx1, 0)) AS totalCote5,
        SUM(IFNULL(cs.coteEx2, 0)) AS totalCote6
        FROM t_cote_sec cs
        JOIN t_cours c ON cs.idCours = c.idCours
        JOIN t_classe cl ON c.idC = cl.idC
        JOIN t_an a ON c.idA = a.idA
        JOIN t_inscrit e ON cs.idI = e.idI
        WHERE cl.idC = :idCl AND a.idA = :idAnn
        GROUP BY cs.idI, e.nom
        ORDER BY (SUM(IFNULL(cs.coteP1, 0)) + SUM(IFNULL(cs.coteP2, 0)) + SUM(IFNULL(cs.coteP3, 0)) + SUM(IFNULL(cs.coteP4, 0))  + SUM(IFNULL(cs.coteEx1, 0)) + SUM(IFNULL(cs.coteEx2, 0))) DESC, e.nom";

    $stmt = $bdd->prepare($sql);
    $stmt->bindParam(':idCl', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idAnn', $annee, PDO::PARAM_INT);
    $stmt->execute();

    $rank = 0;
    $previousTotal = null;
    $previousName = ''; // Initialisez la variable $previousName avec une chaîne vide

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $rank++;
        $eleveId = $row['idI'];
        $totalCote[$eleveId] = $row['totalCote1'] + $row['totalCote2'] + $row['totalCote3'] + $row['totalCote4'] + $row['totalCote5'] + $row['totalCote6'];

        if ($previousTotal !== null && $totalCote[$eleveId] === $previousTotal) {
            $nameComparison = strcasecmp($row['nom'], $previousName);

            // Si les noms sont égaux, conserve le même rang
            if ($nameComparison !== 0) {
                $rank--;
            }
        }

        if ($eleveId == $idI) {
            return $rank;
        }

        $previousTotal = $totalCote[$eleveId];
        $previousName = $row['nom'];
    }

    return null;
}
?>