<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 

//Requete print
$requeteUser="SELECT * FROM agent where etatA='En service' ORDER BY nivA, nomA";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../GRH/agent.php?erreur=$msg_erreur");
    exit;
}else{
    $requeteSomme="SELECT * FROM agent";
    $sommeFacture=$pdo->query($requeteSomme)->rowCount();
 
    $image1 = "../uploads/logo.png";

    $pdf=new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE,",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',15);
    $pdf->cell(0,4,'LISTE DE TOUS LES EMPLOYES',0,0,'C');
    $pdf->Ln(6);

    $pdf->SetTextColor(0,0,0); 
    $pdf->setFont('Arial','U',15);
    $pdf->cell(55,8,'',0);
    $pdf->SetX(3);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(5);
    $pdf->setFont('Arial','B',12);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(55,7,'NOM',1,0,'C');
    $pdf->cell(20,7,'SEXE',1,0,'C');
    $pdf->cell(30,7,'CIVILITE',1,0,'C'); 
    $pdf->cell(30,7,'FONCTION',1,0,'C');
    $pdf->cell(45,7,'SALAIRE',1,0,'C');
    $pdf->Ln(7);

    $currentNiveau = null;
    $pdf->setFont('courier','',9);

    $i=1;
    $resultat=$pdo->query($requeteUser);
    while ($ins=$resultat->fetch()) { 
        if ($ins['nivA'] != $currentNiveau) {
            $pdf->setFont('Arial','B',10);
            $pdf->cell(0, 7, 'ECOLE ' . utf8_decode(strtoupper($ins['nivA'])), 1, 0, 'C');
            $pdf->Ln(7);
            $currentNiveau = $ins['nivA'];
        }
        $pdf->setFont('courier','',9);
        $pdf->cell(10,7, $i++,1,0,'C');
        $pdf->cell(55,7, utf8_decode(substr($ins['nomA'],0,27)),1);
        $pdf->cell(20,7, utf8_decode($ins['sexA']),1);
        $pdf->cell(30,7, utf8_decode($ins['civA']),1);
        $pdf->cell(30,7, utf8_decode(substr($ins['foncA'],0,15)),1);
        $pdf->cell(45,7, utf8_decode(number_format($ins['salA'],2,'.',' ').' $'),1,0,'R');
        $pdf->Ln(7);
    }

    $pdf->setFont('courier','B',9);
    $pdf->cell(115,7,'',0);
    $pdf->cell(30,7,'TOTAL',1);
    $pdf->cell(45,7,$sommeFacture.' Agents',1,0,'R');
    $pdf->Ln(7);

    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(120);
    //Numéro de page
    $pdf->Cell(0,10,' FAIT A KANANGA Le '.date('d-m-Y A h:i:s A').' ',0,0,'C');
    $pdf->Ln(15);
    
    $formatname = "liste-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
?>

