<?php
session_start();
if ( !isset( $_GET[ 'idC' ] ) && !isset( $_GET[ 'idA' ] )) {
    header( 'Location:../index.php' );
}
require_once( '../include/pdf/fpdf.php' );
require_once( '../include/connexiondb.php' );

//Requete print
$idC = $_GET[ 'idC' ];
$idA = $_GET[ 'idA' ];
 
$requeteUser = "SELECT * FROM t_typeFrais 
INNER JOIN t_classe ON t_typeFrais.idC=t_classe.idC 
INNER JOIN t_option ON t_classe.idO=t_option.idO
INNER JOIN t_an ON t_typeFrais.idA=t_an.idA 
WHERE t_an.idA='$idA' AND t_classe.idC='$idC'
ORDER BY t_typeFrais.designTF";

$rowCountRequete = $pdo->query( $requeteUser )->rowCount();
if ( $rowCountRequete === 0 ) {
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../FIN/rec.php?erreur=$msg_erreur");
    exit;
}else{
    $rowRequeteIns = $pdo->query($requeteUser)->fetch();
    $image1 = "../uploads/logo.png";

    $pdf=new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE, ",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',12);
    $pdf->Cell(130 ,5,'LISTE DES FRAIS SCOLAIRES',0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line
    $pdf->Ln(1);
    $pdf->Cell(130 ,5,utf8_decode('Nombre des frais : '.sprintf('%05d', $rowCountRequete)),0,0);
    $pdf->Ln(5);
    $pdf->Cell(130 ,5,utf8_decode('Année Scolaire : '.$rowRequeteIns['designA']),0,0);
    $pdf->Ln(5);
    $pdf->Cell(130 ,5,utf8_decode('Classe : '.$rowRequeteIns['design'].' '.$rowRequeteIns['designO'].' '.$rowRequeteIns['ord']),0,0);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(7);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(120,7,'FRAIS',1,0,'C');
    $pdf->cell(60,7,'MONTANT',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);
    
        $totPaye=0;
        $currentCateg = '';
        $i=1;
        $resultat=$pdo->query($requeteUser);
        while ($ins=$resultat->fetch()) { 
            // Vérifiez si la classe actuelle est différente de la classe précédente
            if ($currentCateg !== $ins['catTF']) {
                $pdf->SetFillColor(200, 200, 200); // Jaune
                $pdf->setFont('courier', 'B', 10);
                $pdf->cell(190, 7, utf8_decode(strtoupper($ins['catTF'])), 1, 1, 'C', true);
                $pdf->SetFillColor(255, 255, 255);
                $currentCateg = $ins['catTF'];
            }
            $pdf->cell(10,7, $i++,1,0,'C');
            $pdf->cell(120,7, utf8_decode(strtoupper($ins['designTF'])),1);
            $pdf->cell(60,7, utf8_decode($ins['montTF'].' $'),1,0,'R');
            $totPaye=$totPaye+$ins['montTF'];
            $pdf->Ln(7);
    }
    $pdf->setFont('Arial','B',10);
    $pdf->cell(130,7,'TOTAL',0,0,'R');
    $pdf->setFont('Arial','B',10);
    $pdf->cell(60,7,number_format($totPaye,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(125);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode(' Fait à Kananga Le '.date('d-m-Y A h:i:s A')),0,0,'C');
    $pdf->Ln(15);
    
    $formatname = "liste-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
?>

