<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 

//Requete print

//Requetes pour les info de base
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$idC=$_POST["idC"];

$requeteUser="SELECT * FROM t_inscrit INNER JOIN  t_classe ON 
t_inscrit.idC=t_classe.idC INNER JOIN t_option ON t_classe.idO=t_option.idO
INNER JOIN t_an ON t_inscrit.idA=t_an.idA WHERE t_inscrit.catEcole='Primaire' 
AND t_inscrit.idC='$idC' AND t_inscrit.idA='$ResultmaxAS' order by t_inscrit.nom ASC";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Admin/inspri.php?erreur=$msg_erreur");
    exit;
}else{
    $rowRequeteIns = $pdo->query($requeteUser)->fetch();
    $rowRequeteInsClasse = $rowRequeteIns['design']." ".$rowRequeteIns['designO']." ".$rowRequeteIns['ord'];
    
    $image1 = "../uploads/logo.png";
    $pdf=new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE,",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',12);
    $pdf->Cell(130 ,5,"LISTE DES ELEVES INSCRITS A L'ECOLE PRIMAIRE",0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Classe : '.$rowRequeteInsClasse),0,0);

    $pdf->Cell(130 ,5,utf8_decode('Nombre des élèves : '.sprintf('%05d', $rowCountRequete)),0,0);
    $pdf->Ln(6);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(5);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(15,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(40,7,'MATRICULE',1,0,'C');
    $pdf->cell(70,7,'NOM COMPLET',1,0,'C');
    $pdf->cell(20,7,'SEXE',1,0,'C');
    $pdf->cell(40,7,'PHOTO',1,0,'C'); // Ajout de la colonne pour les photos
    $pdf->Ln(7);
    
    $pdf->setFont('courier','',9);
    
    $i = 1;
    $resultat = $pdo->query($requeteUser);
    
    // Variables pour les statistiques
    $totalFilles = 0;
    $totalGarcons = 0;
    $totalAvecPhotos = 0;
    $totalSansPhotos = 0;
    
    while ($ins = $resultat->fetch()) {
        
        if($ins['sexe']=="Feminin" || $ins['sexe']=="F") {
            $sexe="F";
            $totalFilles++;
        } else {
            $sexe="M";
            $totalGarcons++;
        }
        
        $pdf->cell(15,7, $i++,1,0,'C');
        $pdf->cell(40,7, utf8_decode(substr($ins['numMat'],0,35)),1);
        $pdf->cell(70,7, utf8_decode(substr($ins['nom'],0,60)),1);
        $pdf->cell(20,7, utf8_decode($sexe),1,0,'C');

        
        // Vérifier si une photo est disponible
        if (empty($ins['photo']) || $ins['photo']=='user.png') {
            $pdf->cell(40,7,'NON DISPO',1);
            $totalSansPhotos++;
        } else {
            $pdf->cell(40,7,'DISPO',1); 
            $totalAvecPhotos++;
        }
        
        $pdf->Ln(7);
    }

    // Ajouter le tableau récapitulatif à la fin
    $pdf->Ln(10);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(0,7,utf8_decode('Récapitulatif des statistiques'),0,1,'L');
    $pdf->Ln(5);
    
    $pdf->cell(60,7,'Total Filles',1,0,'C');
    $pdf->cell(60,7,$totalFilles,1,1,'C');
    
    $pdf->cell(60,7,utf8_decode('Total Garçons'),1,0,'C');
    $pdf->cell(60,7,$totalGarcons,1,1,'C');
    
    $pdf->cell(60,7,'Avec Photos',1,0,'C');
    $pdf->cell(60,7,$totalAvecPhotos,1,1,'C');
    
    $pdf->cell(60,7,'Sans Photos',1,0,'C');
    $pdf->cell(60,7,$totalSansPhotos,1,1,'C');

    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(125);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode(' Fait à Kananga Le '.date('d-m-Y A h:i:s A')),0,0,'C');
    $pdf->Ln(15);
    
    $formatname = "liste-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
?>

