<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");
require_once("../include/fonctionPrint.php");

//Requete print
$idC = $_SESSION['idC'];

//Requetes pour les info de base
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requestMaxAs = "SELECT * FROM t_an WHERE idA='$ResultmaxAS'";
$setMaxAs = $pdo->query($requestMaxAs)->fetch();
$annee = $setMaxAs['idA'];
$desan = $setMaxAs['designA'];

$rqt = "SELECT *
FROM t_classe INNER JOIN t_option ON t_classe.idO = t_option.idO
WHERE t_classe.idC = '$idC'";
$setClasse = $pdo->query($rqt)->fetch();
$classeEl = $setClasse['design'] . ' ' . $setClasse['designO'] . ' ' . $setClasse['ord'];

$requeteInscrit = "SELECT * FROM t_decision
INNER JOIN t_inscrit ON t_decision.idI=t_inscrit.idI
INNER JOIN t_classe ON t_decision.idC=t_classe.idC 
INNER JOIN t_an ON t_decision.idA=t_an.idA 
WHERE t_classe.idC = '$idC' AND t_an.idA = '$annee' AND
decJury='Monte la classe' OR decJury='Double la classe'
ORDER BY pourc DESC";
$stmIns = $pdo->query($requeteInscrit);

$requeteTotIns = "SELECT COUNT(*) AS countIns FROM t_decision
INNER JOIN t_inscrit ON t_decision.idI=t_inscrit.idI
INNER JOIN t_classe ON t_decision.idC=t_classe.idC 
INNER JOIN t_an ON t_decision.idA=t_an.idA 
WHERE t_classe.idC = '$idC' AND t_an.idA = '$annee' AND
decJury='Monte la classe' OR decJury='Double la classe'";
$resultatTotIns = $pdo->query($requeteTotIns)->fetch();
$totIns = $resultatTotIns['countIns'];

$requeteClasse = "SELECT * FROM t_classe WHERE idC = '$idC'";
$resultatClasse = $pdo->query($requeteClasse)->fetch();
$sectionClasse = $resultatClasse['sec'];

$i = 1;


//Design BN
$image1 = "../uploads/logo.png";

$pdf = new FPDF();
$pdf->AddPage();
$pdf->Image($image1, 5, $pdf->GetY(), 36.78);
$pdf->setFont('courier', '', 15);
$pdf->SetTextColor(0, 0, 0);
$pdf->cell(0, 20, "REPUBLIQUE DEMOCRATIQUE DU CONGO", 0, 0, 'C');
$pdf->Ln(15);
$pdf->setFont('courier', '', 15);
$pdf->SetTextColor(0, 0, 0);
$pdf->cell(0, 4, "MINISTERE DE L'ENSEIGNEMENT PRIMAIRE,", 0, 0, 'C');
$pdf->Ln(7);
$pdf->SetTextColor(0, 0, 0);
$pdf->cell(0, 4, "SECONDAIRE ET TECHNIQUE", 0, 0, 'C');
$pdf->Ln(6);
$pdf->setFont('courier', '', 15);
$pdf->cell(0, 4, "COMPLEXE SCOLAIRE LA RECONNAISSANCE", 0, 0, 'C');
$pdf->Ln(10);
$pdf->SetTextColor(0, 0, 0);
$pdf->setFont('courier', 'B', 15);
$pdf->Cell(0, 5, 'PALMARES - '.utf8_decode(mb_strtoupper($classeEl, 'UTF-8')), 0, 0, 'L');
$pdf->SetFont('Arial', '', 10);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Nombre des élèves : ' . $totIns), 0, 0);
$pdf->Cell(130, 5, utf8_decode('Cycle : ' . mb_strtoupper($sectionClasse, 'UTF-8')), 0, 0);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Classe : ' . mb_strtoupper($classeEl, 'UTF-8')), 0, 0);
$pdf->Cell(130, 5, utf8_decode('Année scolaire : ' . $desan), 0, 0);
$pdf->Ln(7);

$pdf->setFont('Arial','B',10);
$pdf->cell(10,5,utf8_decode('N°'),1,0,'C');
$pdf->cell(87,5,'ELEVE',1,0,'C');
$pdf->cell(35,5,'MATRICULE',1,0,'C');
$pdf->cell(30,5,'NATIONALITE',1,0,'C');
$pdf->cell(15,5,'SEXE',1,0,'C');
$pdf->cell(20,5,'%',1,0,'C');
$pdf->Ln(5);

$pdf->setFont('Helvetica','',10);
while ($ins = $stmIns->fetch()){
    $pdf->cell(10,5,$i++,1,0,'C');
    $pdf->cell(87,5,utf8_decode($ins['nom']),1,0,'L');
    $pdf->cell(35,5,utf8_decode($ins['numMat']),1,0,'C');
    $pdf->cell(30,5,utf8_decode($ins['nation']),1,0,'C');
    $pdf->cell(15,5,utf8_decode(strtoupper(substr($ins['sexe'], 0, 1))),1,0,'C');
    $pdf->cell(20,5,utf8_decode($ins['pourc']),1,0,'C');
    $pdf->Ln(5);
}

//Footer
$pdf->setFont('Arial', 'I', 9);
$pdf->Cell(0, 10, utf8_decode('Sceau et Signature'), 0, 0, 'L');
$pdf->Cell(0, 10, utf8_decode(' Fait à Kananga Le ' . date('d-m-Y A h:i:s A')), 0, 0, 'R');

$formatname = "palmares-" . date('dmYhis');
$pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

header('Location: ' . $urlopen . $formatname . '.pdf');
exit;
