<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
require_once("../include/fonctionPrint.php"); 

//Requete print
$idI=$_SESSION['idI'];
$idC=$_SESSION['idC'];
$perConcern=$_SESSION['perConcern'];
//Affichage Des périodes
$aff = "";
if ($perConcern == "S1") {
    $aff = "Premier Trimestre";
}else {
    $aff = "Période non reconnue";
}

//Requetes pour les info de base
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requestMaxAs="SELECT * FROM t_an WHERE idA='$ResultmaxAS'";
$setMaxAs=$pdo->query($requestMaxAs)->fetch();
$annee = $setMaxAs['idA'];
$desan = $setMaxAs['designA'];

$rqt="SELECT *
FROM t_classe INNER JOIN t_option ON t_classe.idO = t_option.idO
WHERE t_classe.idC = '$idC'";
$setClasse=$pdo->query($rqt)->fetch();
$classeEl = $setClasse['design'].' '.$setClasse['designO'].' '.$setClasse['ord'];

$requeteInscrit="SELECT * FROM t_inscrit WHERE idI = '$idI'";
$resultatInscrit=$pdo->query($requeteInscrit)->fetch();
$eleve = $resultatInscrit['nom'];

$requeteClasse="SELECT * FROM t_classe WHERE idC = '$idC'";
$resultatClasse=$pdo->query($requeteClasse)->fetch();
$sectionClasse = $resultatClasse['sec'];

$requeteTotIns="SELECT COUNT(*) AS countIns FROM t_inscrit WHERE idC = '$idC'";
$resultatTotIns=$pdo->query($requeteTotIns)->fetch();
$totIns = $resultatTotIns['countIns'];

//Design BN
$image1 = "../uploads/logo.png";
$pdf=new FPDF();
$pdf->AddPage();
$pdf->Image($image1, 20, 3, 20, 20);
$pdf->setFont('courier','',15);
$pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
$pdf->Ln(10);
$pdf->SetTextColor(0,0,0);
$pdf->setFont('courier','B',13);
$pdf->Cell(0 ,5,'BULLETIN DE NOTES',0,0,'C');
$pdf->SetFont('Arial','',10);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Elève : '.strtoupper($eleve)),0,0);
$pdf->Cell(130 ,5,utf8_decode('Cycle : '.$sectionClasse),0,0);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Classe : '.$classeEl),0,0);
$pdf->Cell(130 ,5,utf8_decode('Année scolaire : '.$desan),0,0);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Période : '.$aff),0,0);
$pdf->Cell(130 ,5,utf8_decode('Date de livraison : Le '.date('d-m-Y')),0,0);
$pdf->Ln(6);
$pdf->setFont('Arial','B',10);
$pdf->cell(12,5,utf8_decode('N°'),1,0,'C');
$pdf->cell(60,5,'COURS',1,0,'C');
$pdf->cell(30,5,'P1',1,0,'C');
$pdf->cell(30,5,'P2',1,0,'C');
$pdf->cell(30,5,'EX',1,0,'C');
$pdf->cell(30,5,'TOTAUX',1,0,'C');
$pdf->Ln(5);

if($sectionClasse=='Primaire'){
    $i = 1;
    //Cotes request
    $reqCote = "SELECT * FROM t_cote_pri INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cote_pri.idI INNER JOIN t_cours ON
    t_cours.idCours = t_cote_pri.idCours WHERE t_inscrit.idI = '$idI'";
    $stmCote=$pdo->query($reqCote);
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_pri INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_pri.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_pri.idC INNER JOIN t_an ON
    t_an.idA = t_cond_pri.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();

    //Affichage cotes
    while ($cotes=$stmCote->fetch()) { 
        $pdf->setFont('courier','',10);
        $pdf->cell(12,5, $i++,1,0,'C');
        $pdf->cell(60,5, utf8_decode($cotes['designCours']),1);
        $pdf->cell(15,5, ($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'R');
        $pdf->setFont('courier','B',10);
        $pdf->cell(15,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        $pdf->setFont('courier','',10);
        $pdf->cell(15,5, ($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'R');
        $pdf->setFont('courier','B',10);
        $pdf->cell(15,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        $pdf->setFont('courier','',10);
        $pdf->cell(15,5, ($cotes['coteEx1']==NULL) ? '' : $cotes['coteEx1'],1,0,'R');
        $pdf->setFont('courier','B',10);
        $pdf->cell(15,5, ($cotes['maxEx']==NULL) ? '' : $cotes['maxEx'],1,0,'R');
        $pdf->setFont('courier','',10);
        $pdf->cell(15,5, ($cotes['coteEx1'] == NULL || $cotes['coteP1'] == NULL || $cotes['coteP2'] == NULL) ? '' : ($cotes['coteP1'] + $cotes['coteP2'] + $cotes['coteEx1']),1,0,'R');
        $pdf->setFont('courier','',10);
        $pdf->cell(15,5, ($cotes['maxEx']==NULL || $cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 2 + $cotes['maxEx']),1,0,'R');
        $pdf->Ln(5);
    }
    //Mes totaux
    $totalCote1 = getTotCotePerPri($pdo,$idI,$annee,'P1');
    $totalCote2 = getTotCotePerPri($pdo,$idI,$annee,'P2');
    $totalCote3 = getTotCotePerPri($pdo,$idI,$annee,'Ex1');
    $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
    $totalMaxEx = getTotExMaxPri($pdo,$idI,$annee);
    // Resultat
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'TOTAUX',1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(15,5,($totalCote1==NULL) ? '' : $totalCote1,1,0,'R');
    $pdf->cell(15,5,($totalMaxPer==NULL) ? '' : $totalMaxPer,1,0,'R');
    $pdf->cell(15,5,($totalCote2==NULL) ? '' : $totalCote2,1,0,'R');
    $pdf->cell(15,5,($totalMaxPer==NULL) ? '' : $totalMaxPer,1,0,'R');
    $pdf->cell(15,5,($totalCote3==NULL) ? '' : $totalCote3,1,0,'R');
    $pdf->cell(15,5,($totalMaxEx==NULL) ? '' : $totalMaxEx,1,0,'R');
    $pdf->cell(15,5,($totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL) ? '' : $totalCote3+$totalCote2+$totalCote1,1,0,'R');
    $pdf->cell(15,5,($totalMaxPer==NULL || $totalMaxEx == NULL) ? '' : ($totalMaxPer*2+$totalMaxEx),1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'POURCENTAGE ',1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5,($totalCote1==NULL) ? '' : round(($totalCote1 / $totalMaxPer) * 100, 2).' %',1,0,'R');
    $pdf->cell(30,5,($totalCote2==NULL) ? '' : round(($totalCote2 / $totalMaxPer) * 100, 2).' %',1,0,'R');
    $pdf->cell(30,5,($totalCote3==NULL) ? '' : round(($totalCote3 / $totalMaxEx) * 100, 2).' %',1,0,'R');
    $pdf->cell(30,5,($totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL) ? '' : round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2).' %',1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'PLACE ',1);
    //Mes fonction
    $place1 = getPlaceElevePriPer($pdo, $idI, $annee, 'P1', $idC);
    $place2 = getPlaceElevePriPer($pdo, $idI, $annee, 'P2', $idC);
    $place3 = getPlaceElevePriPer($pdo, $idI, $annee, 'Ex1', $idC);
    $place4 = getPlaceElevePriTrim1($pdo, $idI, $annee, $idC);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5,(($place1 === 1) ? "1er/".$totIns : (($place1 > 1) ? $place1 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->cell(30,5,(($place2 === 1) ? "1er/".$totIns : (($place2 > 1) ? $place2 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->cell(30,5,(($place3 === 1) ? "1er/".$totIns : (($place3 > 1) ? $place3 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->cell(30,5,(($place4 === 1) ? "1er/".$totIns : (($place4 > 1) ? $place4 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'APPLICATION ',1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5,($totalCote1==NULL) ? '' : calculateGrade(round(($totalCote1 / $totalMaxPer) * 100, 2)),1,0,'R');
    $pdf->cell(30,5,($totalCote2==NULL) ? '' : calculateGrade(round(($totalCote2 / $totalMaxPer) * 100, 2)),1,0,'R');
    $pdf->cell(30,5,($totalCote3==NULL) ? '' : calculateGrade(round(($totalCote3 / $totalMaxEx) * 100, 2)),1,0,'R');
    $pdf->cell(30,5,($totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL) ? '' : calculateGrade(round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2)),1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'CONDUITE ',1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5, ($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'R');
    $pdf->cell(30,5, ($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'R');
    $pdf->cell(30,5, '',1,0,'R');
    $pdf->cell(30,5, '',1,0,'R');
    $pdf->Ln(5);
}elseif($sectionClasse=='Secondaire'){
    $i = 1;
    //Cotes request
    $reqCote = "SELECT * FROM t_cote_sec INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cote_sec.idI INNER JOIN t_cours ON
    t_cours.idCours = t_cote_sec.idCours WHERE t_inscrit.idI = '$idI'";
    $stmCote=$pdo->query($reqCote);
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_sec INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_sec.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_sec.idC INNER JOIN t_an ON
    t_an.idA = t_cond_sec.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();

    //Affichage cotes
    while ($cotes=$stmCote->fetch()) { 
        $pdf->setFont('courier','',10);
        $pdf->cell(12,5, $i++,1,0,'C');
        $pdf->cell(60,5, utf8_decode($cotes['designCours']),1);
        $pdf->cell(15,5, ($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'R');
        $pdf->setFont('courier','B',10);
        $pdf->cell(15,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        $pdf->setFont('courier','',10);
        $pdf->cell(15,5, ($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'R');
        $pdf->setFont('courier','B',10);
        $pdf->cell(15,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        $pdf->setFont('courier','',10);
        $pdf->cell(15,5, ($cotes['coteEx1']==NULL) ? '' : $cotes['coteEx1'],1,0,'R');
        $pdf->setFont('courier','B',10);
        $pdf->cell(15,5, ($cotes['maxEx']==NULL) ? '' : $cotes['maxEx'],1,0,'R');
        $pdf->setFont('courier','',10);
        $pdf->cell(15,5, ($cotes['coteEx1'] == NULL || $cotes['coteP1'] == NULL || $cotes['coteP2'] == NULL) ? '' : ($cotes['coteP1'] + $cotes['coteP2'] + $cotes['coteEx1']),1,0,'R');
        $pdf->setFont('courier','B',10);
        $pdf->cell(15,5, ($cotes['maxEx']==NULL || $cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 2 + $cotes['maxEx']),1,0,'R');
        $pdf->Ln(5);
    }
    //Mes totaux
    $totalCote1 = getTotCotePerSec($pdo,$idI,$annee,'P1');
    $totalCote2 = getTotCotePerSec($pdo,$idI,$annee,'P2');
    $totalCote3 = getTotCotePerSec($pdo,$idI,$annee,'Ex1');
    $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
    $totalMaxEx = getTotExMaxSec($pdo,$idI,$annee);
    // Resultat
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'TOTAUX',1);
    $pdf->cell(15,5,($totalCote1==NULL) ? '' : $totalCote1,1,0,'R');
    $pdf->setFont('Arial','B',9);
    $pdf->cell(15,5,($totalMaxPer==NULL) ? '' : $totalMaxPer,1,0,'R');
    $pdf->setFont('Arial','',9);
    $pdf->cell(15,5,($totalCote2==NULL) ? '' : $totalCote2,1,0,'R');
    $pdf->setFont('Arial','B',9);
    $pdf->cell(15,5,($totalMaxPer==NULL) ? '' : $totalMaxPer,1,0,'R');
    $pdf->setFont('Arial','',9);
    $pdf->cell(15,5,($totalCote3==NULL) ? '' : $totalCote3,1,0,'R');
    $pdf->setFont('Arial','B',9);
    $pdf->cell(15,5,($totalMaxEx==NULL) ? '' : $totalMaxEx,1,0,'R');
    $pdf->setFont('Arial','',9);
    $pdf->cell(15,5,($totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL) ? '' : $totalCote3+$totalCote2+$totalCote1,1,0,'R');
    $pdf->setFont('Arial','B',9);
    $pdf->cell(15,5,($totalMaxPer==NULL || $totalMaxEx == NULL) ? '' : ($totalMaxPer*2+$totalMaxEx),1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'POURCENTAGE ',1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5,($totalCote1==NULL) ? '' : round(($totalCote1 / $totalMaxPer) * 100, 2).' %',1,0,'R');
    $pdf->cell(30,5,($totalCote2==NULL) ? '' : round(($totalCote2 / $totalMaxPer) * 100, 2).' %',1,0,'R');
    $pdf->cell(30,5,($totalCote3==NULL) ? '' : round(($totalCote3 / $totalMaxEx) * 100, 2).' %',1,0,'R');
    $pdf->cell(30,5,($totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL) ? '' : round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2).' %',1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'PLACE ',1);
    //Mes fonction
    $place1 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P1', $idC);
    $place2 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P2', $idC);
    $place3 = getPlaceEleveSecPer($pdo, $idI, $annee, 'Ex1', $idC);
    $place4 = getPlaceEleveSecTrim1($pdo, $idI, $annee, $idC);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5,(($place1 === 1) ? "1er/".$totIns : (($place1 > 1) ? $place1 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->cell(30,5,(($place2 === 1) ? "1er/".$totIns : (($place2 > 1) ? $place2 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->cell(30,5,(($place3 === 1) ? "1er/".$totIns : (($place3 > 1) ? $place3 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->cell(30,5,(($place4 === 1) ? "1er/".$totIns : (($place4 > 1) ? $place4 . utf8_decode("è/").$totIns : "")),1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'APPLICATION ',1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5,($totalCote1==NULL) ? '' : calculateGrade(round(($totalCote1 / $totalMaxPer) * 100, 2)),1,0,'R');
    $pdf->cell(30,5,($totalCote2==NULL) ? '' : calculateGrade(round(($totalCote2 / $totalMaxPer) * 100, 2)),1,0,'R');
    $pdf->cell(30,5,($totalCote3==NULL) ? '' : calculateGrade(round(($totalCote3 / $totalMaxEx) * 100, 2)),1,0,'R');
    $pdf->cell(30,5,($totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL) ? '' : calculateGrade(round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2)),1,0,'R');
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(72,5,'CONDUITE ',1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(30,5, ($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'R');
    $pdf->cell(30,5, ($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'R');
    $pdf->cell(30,5, '',1,0,'R');
    $pdf->cell(30,5, '',1,0,'R');
    $pdf->Ln(5);
}else{
    $pdf->cell(192,5,utf8_decode("IL Y A UNE ERREUR"),1,0,'C');
    $pdf->Ln(5);
}

//Footer
$pdf->setFont('Arial','I',9);
$pdf->Cell(0,10,utf8_decode('Sceau et Signature'),0,0,'L');
$pdf->Cell(0,10,utf8_decode(' Fait à Kananga Le '.date('d-m-Y A h:i:s A')),0,0,'R');

$formatname = "bulletin-" . date('dmYhis');
$pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

header('Location: ' . $urlopen . $formatname . '.pdf');
exit;
?>

