<?php
session_start();
if ( !isset( $_POST[ 'idA' ] )) {
    header( 'Location:../index.php' );
}
require_once( '../include/pdf/fpdf.php' );
require_once( '../include/connexiondb.php' );

//Requete print
$idA = $_POST[ 'idA' ];
 
$requeteUser = "SELECT SUM(montF) as montF,designA,design,designO,ord,
designTF,catTF,nom,montTF,t_typeFrais.idTF,t_classe.idC
FROM t_inscrit INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
INNER JOIN t_an ON t_inscrit.idA=t_an.idA INNER JOIN t_option ON t_classe.idO=t_option.idO
INNER JOIN t_frais ON t_frais.idI = t_inscrit.idI INNER JOIN t_typeFrais ON 
t_typeFrais.idTF = t_frais.idTF  INNER JOIN users ON t_frais.idUser = users.idUser
WHERE t_an.idA='$idA' GROUP BY nom,t_classe.idC,t_typeFrais.designTF";

$listeEleves = $pdo->query( "SELECT * FROM t_inscrit 
    INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC
    INNER JOIN t_option ON t_classe.idO=t_option.idO
      WHERE idA='$idA'" );

$rowCountRequete = $pdo->query( $requeteUser )->rowCount();
if ( $rowCountRequete === 0 ) {
    // Ajoutez un script JavaScript pour revenir à la page précédente
    echo "<script>
    setTimeout(function() {
        window.history.back();
    }, 0); // 0 milliseconde
  </script>";
}else{
    $rowRequeteIns = $pdo->query($requeteUser)->fetch();
    $rowRequeteInsClasse = $rowRequeteIns['design']." ".$rowRequeteIns['designO']." ".$rowRequeteIns['ord'];

    $image1 = "../uploads/logo.png";

    $pdf=new FPDF();
    $pdf->AddPage('L');
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE, ",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',12);
    $pdf->Cell(130 ,5,'RECOUVREMENT DE FRAIS SCOLAIRES',0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line
    $pdf->Ln(1);
    $pdf->Cell(130 ,5,utf8_decode('Nombre des recouvrements : '.sprintf('%05d', $rowCountRequete).' ELEVE(S) A RECOUVRER'),0,0);
    $pdf->Cell(130 ,5,utf8_decode('Année Scolaire : '.$rowRequeteIns['designA']),0,0);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(7);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(100,7,'ELEVE',1,0,'C');
    $pdf->cell(50,7,'FRAIS',1,0,'C');
    $pdf->cell(32,7,'A PAYER',1,0,'C');
    $pdf->cell(33,7,'DEJA PAYE',1,0,'C');
    $pdf->cell(50,7,'RESTE A PAYER',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);
    
        $totPaye=0;
        $currentClasse = '';
        $i=1;
        $resultat=$pdo->query($requeteUser);
        while ($ins=$resultat->fetch()) { 
            // Vérifiez si la classe actuelle est différente de la classe précédente
            if ($currentClasse !== $ins['idC']) {
                $pdf->SetFillColor(200, 200, 200); // Jaune
                $pdf->setFont('courier', 'B', 10);
                $pdf->cell(275, 7, utf8_decode(strtoupper($ins['design'].' '.$ins['designO'].' '.$ins['ord'])), 1, 1, 'C', true);
                $pdf->SetFillColor(255, 255, 255);
                $currentClasse = $ins['idC'];
            }
            $pdf->cell(10,7, $i++,1,0,'C');
            $pdf->cell(100,7, utf8_decode(strtoupper($ins['nom'])),1);
            $pdf->cell(50,7, utf8_decode(strtoupper(substr($ins['designTF'],0,22))),1);
            $pdf->cell(32,7, utf8_decode($ins['montTF'].' $'),1,0,'R');
            $pdf->cell(33,7, utf8_decode($ins['montF'].' $'),1,0,'R');
            $pdf->cell(50,7, utf8_decode(($ins['montTF']-$ins['montF']).' $'),1,0,'R');
            $totPaye=$totPaye+$ins['montTF']-$ins['montF'];
            $pdf->Ln(7);
    }
    $pdf->setFont('Arial','B',10);
    $pdf->cell(192,7,'',0);
    $pdf->cell(33,7,"TOTAL RESTE",1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(50,7,number_format($totPaye,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(125);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode(' Fait à Kananga Le '.date('d-m-Y A h:i:s A')),0,0,'C');
    $pdf->Ln(15);
    
    
    
    //Une autre page
    
    
    
    $pdf->AddPage('L');
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE, ",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',12);
    $pdf->Cell(130 ,5,'RECOUVREMENT DE FRAIS SCOLAIRES (LISTE DES INSOLVABLES)',0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line
    $pdf->Ln(5);
    $pdf->Cell(130 ,5,utf8_decode('Nombre des recouvrements : '.sprintf('%05d', $rowCountRequete).' ELEVE(S) A RECOUVRER'),0,0);
    $pdf->cell(5,8,'',0);
    $pdf->Ln(5);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(100,7,'ELEVE',1,0,'C');
    $pdf->cell(50,7,'FRAIS',1,0,'C');
    $pdf->cell(32,7,'A PAYER',1,0,'C');
    $pdf->cell(33,7,'DEJA PAYE',1,0,'C');
    $pdf->cell(50,7,'RESTE A PAYER',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);
    
        $totPaye=0;

        $i=1;
        $resultat=$pdo->query($requeteUser)->fetch();
        $aPayer=$resultat['montTF'];
        $DesignTF=$resultat['designTF'];
        $type=$resultat['idTF'];
        $currentClasse = '';
        while ($ins=$listeEleves->fetch()) { 
            
            //Exclusion pour ceux là qui ont déjà payé
            $mat=$ins['idI'];
            
            $solvable=$pdo->query("SELECT * FROM t_frais WHERE idI='$mat' AND idTF='$type'");
            if($solvable->fetch()){
                
            }else{
            if ($currentClasse !== $ins['idC']) {
                $pdf->SetFillColor(200, 200, 200); // Jaune
                $pdf->setFont('courier', 'B', 10);
                $pdf->cell(275, 7, utf8_decode(strtoupper($ins['design'].' '.$ins['designO'].' '.$ins['ord'])), 1, 1, 'C', true);
                $pdf->SetFillColor(255, 255, 255);
                $currentClasse = $ins['idC'];
            }
            $pdf->cell(10,7, $i++,1,0,'C');
            $pdf->cell(100,7, utf8_decode(strtoupper($ins['nom'])),1);
            $pdf->cell(50,7, utf8_decode(strtoupper(substr($DesignTF,0,22))),1);
            $pdf->cell(32,7, utf8_decode(substr($aPayer.' $',0,20)),1,0,'R');
            $pdf->cell(33,7, 0,1,0,'R');
            $totPaye=$totPaye+$aPayer;
            $pdf->SetFillColor(209, 206, 206);
            $pdf->cell(50,7, utf8_decode($aPayer.' $'),1,0,'R');
            $pdf->Ln(7);
            }
    }
    $pdf->setFont('Arial','B',10);
    $pdf->cell(192,7,'',0);
    $pdf->cell(33,7,"TOTAL RESTE",1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(50,7,number_format($totPaye,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(207);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode(' Fait à Kananga Le '.date('d-m-Y A h:i:s A')),0,0,'C' );
    $pdf->Ln( 15 );

    $formatname = "rapport-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
?>

