<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");

if (!isset($_POST['idC']) && !isset($_POST['idMCred'])) {
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Stock/serv_cre.php?erreur=$msg_erreur");
    exit;
}

class myPDF extends FPDF
{

    function Table($pdo)
    {
        date_default_timezone_set('Africa/Lubumbashi');
        //Paramettre PRINT
        $requeteParamPrint = "SELECT * FROM parprintmag WHERE idP";
        $resultatPrint = $pdo->query($requeteParamPrint)->fetch();

        //Requete print
        $idC = $_POST['idC'];
        $idMCred = $_POST['idMCred'];

        $requeteUser = "SELECT * FROM mouv_credit INNER JOIN commande ON commande.idC=mouv_credit.idC
        INNER JOIN client ON client.idClient=commande.idClient WHERE idMCred='$idMCred' ";
        $rowCountRequete = $pdo->query($requeteUser)->rowCount();

        $res = $pdo->query($requeteUser)->fetch();
        $nomC = $res['nom'];
        $tel = $res['telephone'];
        $add = $res['adresse'];

        $requeteSomme = "SELECT SUM(prixV*qte) AS sommeFac FROM detail_commande INNER JOIN commande 
        ON commande.idC=detail_commande.idC INNER JOIN 
        client ON client.idClient = commande.idClient WHERE commande.idC='$idC'";
        $resSomme = $pdo->query($requeteSomme)->fetch();
        $sommeFacture = $resSomme['sommeFac'];

        $requetenumFac = "SELECT * FROM mouv_credit";
        $resnumFac = $pdo->query($requetenumFac)->rowCount();
        $numFac = sprintf('%03d', $resnumFac);

        $resultat = $pdo->query($requeteUser);
        $ins = $resultat->fetch();

        $image1 = "../uploads/" . $resultatPrint['log'];

        $this->AddPage();

        // En-tête de page
        $this->SetFont('courier', 'B', 10);
        $this->Cell(90, 0, $resultatPrint['soc'], 0, 0, 'C');
        $this->SetFont('courier', '', 10);
        $this->Ln(4);
        $this->Cell(90, 0, $resultatPrint['pays'], 0, 0, 'C');
        $this->Ln(4);
        $this->Cell(90, 0, 'Contact : ' . $resultatPrint['con'], 0, 0, 'C');
        $this->Ln(2);
        $this->SetX(1);
        $this->Image($image1, 1, 7, 15, 15);
        $this->Line(0, 25, 270 - 50, 25);
        $this->Ln(7);

        // Reste de l'en-tête
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 6, utf8_decode('RECU DE PAIEMENT CREDIT N° ') . $numFac, 0, 1, 'C');
        $this->Ln(2);

        // Informations sur l'étudiant alignées à droite
        $this->SetFont('Helvetica', '', 10);
        $this->Cell(14, 5, 'Client : ', 0, 0, 'L');
        $this->SetFont('Helvetica', 'B', 10);
        $this->Cell(0, 5, strtoupper($nomC), 0, 1, 'L');

        $this->SetFont('Helvetica', '', 10);
        $this->Cell(16, 5, 'Adresse : ', 0, 0, 'L');
        $this->SetFont('Helvetica', 'B', 10);
        $this->Cell(0, 5, strtoupper($add), 0, 1, 'L');

        $this->SetFont('Helvetica', '', 10);
        $this->Cell(20, 5, utf8_decode('Téléphone : '), 0, 0, 'L');
        $this->SetFont('Helvetica', 'B', 10);
        $this->Cell(0, 5, strtoupper($tel), 0, 1, 'L');

        $this->SetFont('Helvetica', '', 10);
        $this->Cell(20, 5, 'Facture du : ', 0, 0, 'L');
        $this->SetFont('Helvetica', 'B', 10);
        $this->Cell(0, 5, date('d-m-Y', strtotime($ins['dateCreance'])), 0, 1, 'L');

        // Montant payé et Reste à payer
        $this->SetFont('Helvetica', '', 10);
        $this->Cell(25, 5, utf8_decode('Montant payé : '), 0, 0, 'L');
        $this->SetFont('Helvetica', 'B', 10);
        $this->Cell(0, 5, number_format($ins['montant'], 2, '.', ' ') . ' FC', 0, 1, 'L');

        $this->SetFont('Helvetica', '', 10);
        $this->Cell(29, 5, utf8_decode('Montant à payer : '), 0, 0, 'L');
        $this->SetFont('Helvetica', 'B', 10);
        $this->Cell(0, 5, number_format($sommeFacture, 2, '.', ' ') . ' FC', 0, 1, 'L');

        $this->SetFont('Helvetica', '', 10);
        $this->Cell(26, 5, utf8_decode('Reste à payer : '), 0, 0, 'L');
        $this->SetFont('Helvetica', 'B', 10);
        $this->Cell(0, 5, number_format($ins['reste'], 2, '.', ' ') . ' FC', 0, 1, 'L');

        // Pied de page
        $this->Ln(3);
        $this->SetFont('Arial', 'I', 9);
        $this->Cell(0, 3, utf8_decode('Fait à ' . $resultatPrint['vil']) . ' Le ' . date('d-m-Y H:i:s') . ' ', 0, 1, 'R');
    }
}

$pdf = new myPDF('p', 'mm', array(100, 107));
$pdf->AliasNbPages();
$pdf->Table($pdo);

$formatname = "recucredit-" . date('dmYhis');
$uploadRep = "../uploads/pdfs/";
$pdf->Output($uploadRep . $formatname . '.pdf', 'F');
header('Location:' . $uploadRep . $formatname . '.pdf');
exit;
