<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");

if (!isset($_POST['idF'])) {
    echo "<script>
     setTimeout(function() {
         window.history.back();
     }, 0); // 0 milliseconde
   </script>";
    exit;
}

class myPDF extends FPDF
{
    function Header()
{
    
    // Texte en haut de page
    $this->SetFont('courier', 'B', 6); // Police réduite et gras
    $this->Cell(0, 0, utf8_decode('REPUBLIQUE DEMOCRATIQUE DU CONGO'), 0, 1, 'C');
    $this->Ln(3); // Saut de ligne

    $this->Cell(0, 0, utf8_decode("MINISTERE DE L'EDUCATION NATIONALE"), 0, 1, 'C');
    $this->Ln(3);

    // Ajouter une image centrée (logo)
    $imageWidth = 12;  // Largeur de l'image
    $imageX = ($this->GetPageWidth() - $imageWidth) / 2; // Calcul pour centrer
    $this->Image('../uploads/logo.png', $imageX, $this->GetY(), $imageWidth, 12);
    $this->Ln(15); // Saut de ligne après l'image

    // Ajouter le nom de l'institution
    $this->SetFont('courier', 'B', 6);
    $this->Cell(0, 0, utf8_decode('COMPLEXE SCOLAIRE LA RECONNAISSANCE'), 0, 1, 'C');
    $this->Ln(3); // Saut de ligne
}



    function Table($pdo)
{
    $idF = $_POST['idF'];
    $requser = $pdo->query("SELECT * FROM t_inscrit
    INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
    INNER JOIN t_an ON t_inscrit.idA=t_an.idA 
    INNER JOIN t_option ON t_classe.idO=t_option.idO 
    INNER JOIN t_frais ON t_frais.idI = t_inscrit.idI 
    INNER JOIN t_typeFrais ON t_typeFrais.idTF = t_frais.idTF 
    INNER JOIN users ON t_frais.idUser = users.idUser  
    WHERE t_frais.idF='$idF'");

    while ($userinf = $requser->fetch()) {
        $numMat = $userinf['idI'];

        $dejaPayer = $pdo->query("SELECT SUM(t_frais.montF) AS dejaPayer
        FROM t_inscrit
        INNER JOIN t_classe ON t_inscrit.idC=t_classe.idC 
        INNER JOIN t_an ON t_inscrit.idA=t_an.idA 
        INNER JOIN t_option ON t_classe.idO=t_option.idO 
        INNER JOIN t_frais ON t_frais.idI = t_inscrit.idI 
        INNER JOIN t_typeFrais ON t_typeFrais.idTF = t_frais.idTF 
        INNER JOIN users ON t_frais.idUser = users.idUser  
        WHERE t_inscrit.idI='$numMat' AND t_frais.idF='$idF'")->fetch();
        $montantDejaPaye = $dejaPayer['dejaPayer'];
        $map = $userinf['montTF'];
        $resteAPayer = $map - $montantDejaPaye;

        $this->AddPage();

        // Positionner le contenu près du bord gauche
        $this->SetX(5); // Décaler toutes les lignes à 5 mm du bord gauche

        // Informations principales
        $this->SetFont('Arial', 'B', 8);
        $this->Cell(0, 6, utf8_decode("REÇU N°" . sprintf('%06d', $userinf['idF'])), 0, 1, 'C');
        $this->Ln(3);

        // Contenu principal (format compact après les ":")
        $this->SetX(5);
        $this->SetFont('Helvetica', '', 6);
        $this->Cell(0, 4, utf8_decode('Nom : ' . $userinf['nom']), 0, 1);

        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Classe : ' . $userinf['design'] . ' ' . $userinf['designO'] . ' ' . $userinf['ord']), 0, 1);

        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Année : ' . $userinf['designA']), 0, 1);

        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Motif : ' . $userinf['designTF']), 0, 1);

        $this->Ln(2);

        // Montants
        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Montant payé : ' . $userinf['montF'] . ' $'), 0, 1);

        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Montant dû : ' . $map . ' $'), 0, 1);

        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Déjà payé : ' . $montantDejaPaye . ' $'), 0, 1);

        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Reste à payer : ' . $resteAPayer . ' $'), 0, 1);

        $this->Ln(4);

        // Signature
        $this->SetX(5);
        $this->SetFont('Arial', 'I', 5);
        $this->Cell(0, 4, utf8_decode('Fait à Kananga le ') . date('d-m-Y'), 0, 1, 'R');
        $this->SetX(5);
        $this->Cell(0, 4, utf8_decode('Imprimé par ') . $userinf['nomUser'], 0, 1, 'R');
    }
}



}


$formatname = "recupaye-" . date('dmYhis');
$pdf = new myPDF('P', 'mm', array(58, 120)); // Dimensions adaptées à l'imprimante POS
$pdf->AliasNbPages();
$pdf->Table($pdo);
$pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

header('Location: ' . $urlopen . $formatname . '.pdf');
exit;
