<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
date_default_timezone_set('Africa/Lubumbashi');

//Paramettre PRINT
$requeteParamPrint="SELECT * FROM parprintmag WHERE idP";
$resultatPrint=$pdo->query($requeteParamPrint)->fetch();

//Requete print
$requeteUser="SELECT * FROM medicament INNER JOIN 
categorie ON medicament.idCat=categorie.idCat
ORDER BY categorie.designCat, medicament.design";
$currentCategory = null;
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    // Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Stock/med.php?erreur=$msg_erreur");
    exit;
} else {
    $requeteQuant="SELECT SUM(paEn) AS totPA, SUM(stock) AS totSTOCK, SUM(pvg) AS totPV,
     SUM(paEn*stock) AS totPAT, SUM(pvg*stock) AS totPVT FROM medicament";
    $rowCountQuant = $pdo->query($requeteQuant)->fetch();
    $totPA = $rowCountQuant['totPA'];
    $totPV = $rowCountQuant['totPV'];
    $totPAT = $rowCountQuant['totPAT'];
    $totPVT = $rowCountQuant['totPVT'];
    $totSTOCK = $rowCountQuant['totSTOCK'];

    $image1 = "../uploads/".$resultatPrint['log'];

    $pdf = new FPDF();
    $pdf->AddPage('L');
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('Arial','B',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,$resultatPrint['soc'],0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,$resultatPrint['ad'],0,0,'C');
    $pdf->Ln(7);
    $pdf->cell(0,4,$resultatPrint['pays'],0,0,'C');
    $pdf->Ln(6);
    $pdf->cell(0,4,'Contact : '.$resultatPrint['con'],0,0,'C');
    $pdf->Ln(6);
    $pdf->cell(0,4,'Email : '.$resultatPrint['em'],0,0,'C');
    $pdf->Ln(10);
    $pdf->setFont('courier','B',15);
    $pdf->cell(0,4,'SITUATION GENERALE DU STOCK',0,0,'C');
    $pdf->Ln(6);

    $pdf->setFont('Arial','U',15);
    $pdf->cell(55,8,'',0);
    $pdf->SetX(3);
    $pdf->cell(5,8,'',0);
    $pdf->Ln(5);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(15,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(55,7,'PRODUIT',1,0,'C');
    $pdf->cell(35,7,'STOCK',1,0,'C');
    $pdf->cell(45,7,'PAU',1,0,'C');
    $pdf->cell(45,7,'PAT',1,0,'C');
    $pdf->cell(45,7,'PV',1,0,'C');
    $pdf->cell(45,7,'PVT',1,0,'C');
    $pdf->Ln(7);

    $i = 1;
    $resultat = $pdo->query($requeteUser);
    $totalCat = 0;
    $subtotalPVT = 0;
    
    while ($ins = $resultat->fetch()) { 
        if ($currentCategory !== $ins['designCat']) {
            // If it's not the first category, print the subtotal for the previous category
            if ($currentCategory !== null) {
                $pdf->setFont('courier','B',9);
                $pdf->cell(240,7,'Sous Total : ',1,0,'R');
                $pdf->cell(45,7,number_format($subtotalPVT,2,'.',' '),1,0,'R');
                $pdf->Ln(7);
                $subtotalPVT = 0;
            }
            
            // Nouvelle catégorie, affichez un en-tête
            $pdf->SetFillColor(255, 255, 0); // Jaune
            $pdf->setFont('courier', 'B', 10);
            $pdf->cell(285, 6, utf8_decode(strtoupper($ins['designCat'])), 1, 1, 'C', true);
            $pdf->SetFillColor(255, 255, 255);
            $currentCategory = $ins['designCat'];
        }
        
        $pdf->setFont('courier','',9);
        $pdf->cell(15,7, $i++,1,0,'C');
        $pdf->cell(55,7, utf8_decode(substr($ins['design'],0,25)),1);
        $pdf->cell(35,7, utf8_decode(substr($ins['stock'],0,20)),1,0,'R');
        $pdf->cell(45,7, utf8_decode(number_format($ins['paEn'],2,'.',' ')),1,0,'R');
        $pdf->cell(45,7, utf8_decode(number_format($ins['paEn']*$ins['stock'],2,'.',' ')),1,0,'R');
        $pdf->cell(45,7, utf8_decode(number_format($ins['pvg'],2,'.',' ')),1,0,'R');
        $pdf->cell(45,7, utf8_decode(number_format($ins['pvg']*$ins['stock'],2,'.',' ')),1,0,'R');
        
        $pdf->Ln(7);
        $subtotalPVT += $ins['pvg'] * $ins['stock'];
    }

    // Print the last category subtotal
    if ($currentCategory !== null) {
        $pdf->setFont('courier','B',9);
        $pdf->cell(240,7,'Sous Total : ',1,0,'R');
        $pdf->cell(45,7,number_format($subtotalPVT,2,'.',' '),1,0,'R');
        $pdf->Ln(7);
    }

    $pdf->setFont('courier','B',9);
    $pdf->cell(15,7,'TOTAUX',0);
    $pdf->cell(55,7,$rowCountRequete.' Produits',1,0,'R');
    $pdf->cell(35,7,number_format($totSTOCK,2,'.',' '),1,0,'R');
    $pdf->cell(45,7,number_format($totPA,2,'.',' ').' FC',1,0,'R');
    $pdf->cell(45,7,number_format($totPAT,2,'.',' ').' FC',1,0,'R');
    $pdf->cell(45,7,number_format($totPV,2,'.',' ').' FC',1,0,'R');
    $pdf->cell(45,7,number_format($totPVT,2,'.',' ').' FC',1,0,'R');
    $pdf->Ln(7);

    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(222);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode('Fait à '.$resultatPrint['vil']).' Le '.date('d-m-Y H:i:s').' ',0,0,'C');
    $pdf->Ln(15);
    
    $formatname = "rapport-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
?>
